/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.osgi.BundleInfo;
import org.apache.sling.testing.clients.osgi.BundlesInfo;
import org.apache.sling.testing.clients.osgi.ComponentInfo;
import org.apache.sling.testing.clients.osgi.ComponentsInfo;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.AbstractPoller;
import org.apache.sling.testing.clients.util.poller.PathPoller;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiConsoleClient
extends SlingClient {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiConsoleClient.class);
    private final String CONSOLE_ROOT_URL = "/system/console";
    private final String URL_CONFIGURATION = "/system/console/configMgr";
    private final String URL_BUNDLES = "/system/console/bundles";
    private final String URL_COMPONENTS = "/system/console/components";
    public static final String JSON_KEY_ID = "id";
    public static final String JSON_KEY_VERSION = "version";
    public static final String JSON_KEY_DATA = "data";
    public static final String JSON_KEY_STATE = "state";

    public OsgiConsoleClient(URI serverUrl, String userName, String password) throws ClientException {
        super(serverUrl, userName, password);
    }

    public OsgiConsoleClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public BundlesInfo getBundlesInfo(int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/bundles.json", HttpUtils.getExpectedStatus(200, expectedStatus));
        return new BundlesInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public BundleInfo getBundleInfo(String id, int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/bundles/" + id + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new BundleInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public ComponentsInfo getComponentsInfo(int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/components.json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new ComponentsInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public ComponentInfo getComponentInfo(String id, int expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/components/" + id + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new ComponentInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public Map<String, Object> getConfiguration(String pid, int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + pid, null, new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(resp.getContent());
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (rootNode.get("properties") == null) {
            return props;
        }
        JsonNode properties = rootNode.get("properties");
        Iterator it = properties.getFieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            JsonNode value = properties.get(propName).get("value");
            if (value != null) {
                props.put(propName, value.getValueAsText());
                continue;
            }
            value = properties.get(propName).get("values");
            if (value == null) continue;
            Iterator iter = value.getElements();
            ArrayList<String> list = new ArrayList<String>();
            while (iter.hasNext()) {
                list.add(((JsonNode)iter.next()).getValueAsText());
            }
            props.put(propName, list.toArray(new String[list.size()]));
        }
        return props;
    }

    public Map<String, Object> getConfigurationWithWait(long waitCount, String pid, int ... expectedStatus) throws ClientException, InterruptedException {
        ConfigurationPoller poller = new ConfigurationPoller(500L, waitCount, pid, expectedStatus);
        if (!poller.callUntilCondition()) {
            return this.getConfiguration(pid, expectedStatus);
        }
        return poller.getConfig();
    }

    public String editConfiguration(String PID, String factoryPID, Map<String, Object> configProperties, int ... expectedStatus) throws ClientException {
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("apply", "true");
        builder.addParameter("action", "ajaxConfigManager");
        if (factoryPID != null) {
            builder.addParameter("factoryPid", factoryPID);
        }
        StringBuilder propertyList = new StringBuilder("");
        for (String propName : configProperties.keySet()) {
            Object o = configProperties.get(propName);
            if (o instanceof String) {
                builder.addParameter(propName, (String)o);
            } else if (o instanceof String[]) {
                for (String s : (String[])o) {
                    builder.addParameter(propName, s);
                }
            }
            propertyList.append(propName).append(",");
        }
        builder.addParameter("propertylist", propertyList.substring(0, propertyList.length() - 1));
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + PID, (HttpEntity)builder.build(), new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(302, expectedStatus));
        Header[] locationHeader = resp.getHeaders("Location");
        if (locationHeader != null && locationHeader.length == 1) {
            return locationHeader[0].getValue().substring("/system/console/configMgr".length() + 1);
        }
        return null;
    }

    public String editConfigurationWithWait(int waitCount, String PID, String factoryPID, Map<String, Object> configProperties, int ... expectedStatus) throws ClientException, InterruptedException {
        String pid = this.editConfiguration(PID, factoryPID, configProperties, expectedStatus);
        this.getConfigurationWithWait(waitCount, pid, new int[0]);
        return pid;
    }

    public SlingHttpResponse deleteConfiguration(String pid, int ... expectedStatus) throws ClientException {
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("apply", "1");
        builder.addParameter("delete", "1");
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + pid, (HttpEntity)builder.build(), new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return resp;
    }

    public SlingHttpResponse uninstallBundle(String symbolicName) throws ClientException {
        long bundleId = this.getBundleId(symbolicName);
        LOG.info("Uninstalling bundle {} with bundleId {}", (Object)symbolicName, (Object)bundleId);
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("action", "uninstall");
        return this.doPost(this.getBundlePath(symbolicName), (HttpEntity)builder.build(), 200);
    }

    public SlingHttpResponse installBundle(File f, boolean startBundle) throws ClientException {
        return this.installBundle(f, startBundle, 0);
    }

    public SlingHttpResponse installBundle(File f, boolean startBundle, int startLevel) throws ClientException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addTextBody("action", "install").addBinaryBody("bundlefile", f);
        if (startBundle) {
            builder.addTextBody("bundlestart", "true");
        }
        if (startLevel > 0) {
            builder.addTextBody("bundlestartlevel", String.valueOf(startLevel));
            LOG.info("Installing bundle {} at start level {}", (Object)f.getName(), (Object)startLevel);
        } else {
            LOG.info("Installing bundle {} at default start level", (Object)f.getName());
        }
        return this.doPost("/system/console/bundles", builder.build(), 302);
    }

    public boolean installBundleWithRetry(File f, boolean startBundle, int startLevel, int waitTime, int retries) throws ClientException, InterruptedException {
        this.installBundle(f, startBundle, startLevel);
        try {
            return this.checkBundleInstalled(OsgiConsoleClient.getBundleSymbolicName(f), waitTime, retries);
        }
        catch (IOException e) {
            throw new ClientException("Cannot get bundle symbolic name", e);
        }
    }

    public boolean checkBundleInstalled(String symbolicName, int waitTime, int retries) throws InterruptedException {
        String path = this.getBundlePath(symbolicName, ".json");
        return new PathPoller(this, path, waitTime, retries, new int[0]).callAndWait();
    }

    public long getBundleId(String symbolicName) throws ClientException {
        JSONObject bundle = this.getBundleData(symbolicName);
        try {
            return bundle.getLong(JSON_KEY_ID);
        }
        catch (JSONException e) {
            throw new ClientException("Cannot get id from json", e);
        }
    }

    public String getBundleVersion(String symbolicName) throws ClientException {
        JSONObject bundle = this.getBundleData(symbolicName);
        try {
            return bundle.getString(JSON_KEY_VERSION);
        }
        catch (JSONException e) {
            throw new ClientException("Cannot get version from json", e);
        }
    }

    public String getBundleState(String symbolicName) throws ClientException {
        JSONObject bundle = this.getBundleData(symbolicName);
        try {
            return bundle.getString(JSON_KEY_STATE);
        }
        catch (JSONException e) {
            throw new ClientException("Cannot get state from json", e);
        }
    }

    public void startBundle(String symbolicName) throws ClientException {
        String path = this.getBundlePath(symbolicName);
        LOG.info("Starting bundle {} via {}", (Object)symbolicName, (Object)path);
        this.doPost(path, (HttpEntity)FormEntityBuilder.create().addParameter("action", "start").build(), 200);
    }

    public void startBundlewithWait(String symbolicName, int waitTime, int retries) throws ClientException, InterruptedException {
        this.startBundle(symbolicName);
        this.checkBundleInstalled(symbolicName, waitTime, retries);
    }

    public void refreshPackages() throws ClientException {
        LOG.info("Refreshing packages.");
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("action", "refreshPackages");
        this.doPost("/system/console/bundles", (HttpEntity)builder.build(), 200);
    }

    private String getBundlePath(String symbolicName, String extension) {
        return this.getBundlePath(symbolicName) + extension;
    }

    private String getBundlePath(String symbolicName) {
        return "/system/console/bundles/" + symbolicName;
    }

    private JSONObject getBundleData(String symbolicName) throws ClientException {
        String path = this.getBundlePath(symbolicName, ".json");
        String content = this.doGet(path, 200).getContent();
        try {
            JSONObject root = new JSONObject(content);
            if (!root.has(JSON_KEY_DATA)) {
                throw new ClientException(path + " does not provide '" + JSON_KEY_DATA + "' element, JSON content=" + content);
            }
            JSONArray data = root.getJSONArray(JSON_KEY_DATA);
            if (data.length() < 1) {
                throw new ClientException(path + "." + JSON_KEY_DATA + " is empty, JSON content=" + content);
            }
            JSONObject bundle = data.getJSONObject(0);
            if (!bundle.has(JSON_KEY_STATE)) {
                throw new ClientException(path + ".data[0].state missing, JSON content=" + content);
            }
            return bundle;
        }
        catch (JSONException e) {
            throw new ClientException("Cannot get json", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleSymbolicName(File bundleFile) throws IOException {
        String name = null;
        try (JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));){
            Manifest m = jis.getManifest();
            if (m == null) {
                throw new IOException("Manifest is null in " + bundleFile.getAbsolutePath());
            }
            name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleVersionFromFile(File bundleFile) throws IOException {
        String version = null;
        try (JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));){
            Manifest m = jis.getManifest();
            if (m == null) {
                throw new IOException("Manifest is null in " + bundleFile.getAbsolutePath());
            }
            version = m.getMainAttributes().getValue("Bundle-Version");
        }
        return version;
    }

    class ConfigurationPoller
    extends AbstractPoller {
        private final String pid;
        int[] expectedStatus;
        public Map<String, Object> config;

        public ConfigurationPoller(long waitInterval, long waitCount, String pid, int ... expectedStatus) {
            super(waitInterval, waitCount);
            this.pid = pid;
            this.config = null;
            this.expectedStatus = expectedStatus;
        }

        @Override
        public boolean call() {
            try {
                this.config = OsgiConsoleClient.this.getConfiguration(this.pid, this.expectedStatus);
            }
            catch (ClientException e) {
                LOG.warn("Couldn't get config " + this.pid, (Throwable)e);
            }
            return true;
        }

        @Override
        public boolean condition() {
            return null != this.config;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }
    }
}

