/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.Map;
import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInstanceConfig
implements InstanceConfig {
    protected int waitCount = 20;
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstanceConfig.class);
    private final OsgiConsoleClient osgiClient;
    private final String configPID;
    private Map<String, Object> config;

    public <T extends SlingClient> OsgiInstanceConfig(T client, String configPID) throws ClientException, InstanceConfigException {
        this.osgiClient = ((AbstractSlingClient)client).adaptTo(OsgiConsoleClient.class);
        this.configPID = configPID;
        this.save();
    }

    @Override
    public InstanceConfig save() throws InstanceConfigException {
        try {
            this.config = this.osgiClient.getConfigurationWithWait(this.waitCount, this.configPID, new int[0]);
            LOG.info("Saved OSGi config for {}. It is currently this: {}", (Object)this.configPID, this.config);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Error getting config", e);
        }
        catch (InterruptedException e) {
            throw new InstanceConfigException("Saving configuration was interrupted ", e);
        }
        return this;
    }

    @Override
    public InstanceConfig restore() throws InstanceConfigException {
        try {
            this.osgiClient.editConfigurationWithWait(this.waitCount, this.configPID, null, this.config, new int[0]);
            LOG.info("restored OSGi config for {}. It is now this: {}", (Object)this.configPID, this.config);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not edit OSGi configuration", e);
        }
        catch (InterruptedException e) {
            throw new InstanceConfigException("Restoring configuration was interrupted", e);
        }
        return this;
    }
}

