/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util.poller;

import org.apache.sling.testing.clients.util.poller.Poller;

public abstract class AbstractPoller
implements Poller {
    private final long waitInterval;
    private final long waitCount;

    public AbstractPoller(long waitInterval, long waitCount) {
        this.waitInterval = waitInterval;
        this.waitCount = waitCount;
    }

    @Override
    public boolean callAndWait() throws InterruptedException {
        if (!this.call()) {
            return false;
        }
        int i = 0;
        while ((long)i < this.waitCount) {
            if (this.condition()) {
                return true;
            }
            Thread.sleep(this.waitInterval);
            ++i;
        }
        return false;
    }

    @Override
    public boolean callUntilCondition() throws InterruptedException {
        if (!this.call()) {
            return false;
        }
        if (this.condition()) {
            return true;
        }
        int i = 0;
        while ((long)i < this.waitCount) {
            Thread.sleep(this.waitInterval);
            if (!this.call()) {
                return false;
            }
            if (this.condition()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

