/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util.poller;

import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.poller.AbstractPoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPoller
extends AbstractPoller {
    private static final Logger LOG = LoggerFactory.getLogger(PathPoller.class);
    private final AbstractSlingClient client;
    private final String path;
    private final int[] expectedStatus;
    private Exception exception;

    public PathPoller(AbstractSlingClient client, String path, long waitInterval, long waitCount, int ... expectedStatus) {
        super(waitInterval, waitCount);
        this.client = client;
        this.path = path;
        this.expectedStatus = null == expectedStatus || expectedStatus.length == 0 ? new int[]{200} : expectedStatus;
    }

    @Override
    public boolean call() {
        return true;
    }

    @Override
    public boolean condition() {
        try {
            this.client.doGet(this.path, this.expectedStatus);
        }
        catch (ClientException e) {
            LOG.warn("Get on {} failed: {}", (Object)this.path, (Object)e);
            this.exception = e;
            return false;
        }
        return true;
    }

    public Exception getException() {
        return this.exception;
    }
}

