/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util.poller;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.timeouts.TimeoutsProvider;

public class Polling
implements Callable<Boolean> {
    protected final Callable<Boolean> c;
    protected Exception lastException;

    public Polling() {
        this.c = null;
        this.lastException = null;
    }

    public Polling(Callable<Boolean> c) {
        this.c = c;
        this.lastException = null;
    }

    @Override
    public Boolean call() throws Exception {
        if (this.c != null) {
            return this.c.call();
        }
        return false;
    }

    public void poll(long timeout, long delay) throws TimeoutException, InterruptedException {
        long start = System.currentTimeMillis();
        long effectiveTimeout = TimeoutsProvider.getInstance().getTimeout(timeout);
        do {
            try {
                boolean success = this.call();
                if (success) {
                    return;
                }
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.lastException = e;
            }
        } while (System.currentTimeMillis() < start + effectiveTimeout);
        throw new TimeoutException(String.format(this.message(), effectiveTimeout, delay));
    }

    protected String message() {
        return "Call failed to return true in %1$d ms. Last exception was: " + this.lastException;
    }
}

