/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.sling.testing.clients.ClientException;

public class SlingHttpResponse
implements CloseableHttpResponse {
    public static final String STATUS = "Status";
    public static final String MESSAGE = "Message";
    public static final String LOCATION = "Location";
    public static final String PARENT_LOCATION = "ParentLocation";
    public static final String PATH = "Path";
    public static final String REFERER = "Referer";
    public static final String CHANGE_LOG = "ChangeLog";
    private final CloseableHttpResponse httpResponse;
    private String content;

    public SlingHttpResponse(CloseableHttpResponse response) {
        this.httpResponse = response;
    }

    public String getContent() {
        if (!this.isConsumed()) {
            try {
                this.content = EntityUtils.toString((HttpEntity)this.getEntity());
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read content from response", e);
            }
        }
        return this.content;
    }

    public boolean isConsumed() {
        return this.content != null || this.getEntity() == null;
    }

    public void checkStatus(int expected) throws ClientException {
        if (this.getStatusLine().getStatusCode() != expected) {
            throw new ClientException(this + " has wrong response status (" + this.getStatusLine().getStatusCode() + "). Expected " + expected);
        }
    }

    public void checkContentType(String expected) throws ClientException {
        String contentType = this.getEntity().getContentType().getValue();
        if (contentType != null) {
            contentType = contentType.split(";")[0].trim();
        }
        if (!contentType.equals(expected)) {
            throw new ClientException(this + " has wrong content type (" + contentType + "). Expected " + expected);
        }
    }

    public void checkContentRegexp(String ... regexp) throws ClientException {
        for (String expr : regexp) {
            Pattern p = Pattern.compile(".*" + expr + ".*");
            Scanner scanner = new Scanner(this.getContent());
            boolean matched = false;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!p.matcher(line).matches()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new ClientException("Pattern " + p + " didn't match any line in content");
        }
    }

    public void checkContentContains(String ... expected) throws ClientException {
        for (String s : expected) {
            if (this.getContent().contains(s)) continue;
            throw new ClientException("Content does not contain string " + s + ". Content is: \n\n" + this.getContent());
        }
    }

    public String getSlingStatus() {
        String searchPattern = "id=\"Status\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public int getSlingStatusAsInt() throws NumberFormatException {
        String strStatus = this.getSlingStatus();
        return Integer.parseInt(strStatus);
    }

    public String getSlingMessage() {
        String searchPattern = "id=\"Message\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String[] getSlingCopyPaths() {
        String copyPaths = this.getSlingMessage();
        StringTokenizer tokenizer = new StringTokenizer(copyPaths);
        ArrayList<String> copies = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            copies.add(tokenizer.nextToken());
        }
        return copies.toArray(new String[copies.size()]);
    }

    public String getSlingLocation() {
        String searchPattern = "id=\"Location\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getSlingParentLocation() {
        String searchPattern = "id=\"ParentLocation\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getSlingPath() {
        String searchPattern = "id=\"Path\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getSlingReferer() {
        String searchPattern = "id=\"Referer\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getSlingChangeLog() {
        String searchPattern = "id=\"ChangeLog\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    protected String extractFromHTMLResponse(String searchPattern) {
        String tmpResponse = null;
        int start = this.getContent().indexOf(searchPattern);
        if (start > 0) {
            tmpResponse = this.getContent().substring(start += searchPattern.length());
            int end = tmpResponse.indexOf("<");
            tmpResponse = tmpResponse.substring(0, end);
        }
        return tmpResponse;
    }

    public StatusLine getStatusLine() {
        return this.httpResponse.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.httpResponse.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.httpResponse.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.httpResponse.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.httpResponse.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.httpResponse.setReasonPhrase(reason);
    }

    public HttpEntity getEntity() {
        return this.httpResponse.getEntity();
    }

    public void setEntity(HttpEntity entity) {
        this.httpResponse.setEntity(entity);
    }

    public Locale getLocale() {
        return this.httpResponse.getLocale();
    }

    public void setLocale(Locale loc) {
        this.httpResponse.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.httpResponse.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.httpResponse.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.httpResponse.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.httpResponse.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.httpResponse.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.httpResponse.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.httpResponse.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.httpResponse.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.httpResponse.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.httpResponse.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.httpResponse.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.httpResponse.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.httpResponse.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.httpResponse.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.httpResponse.headerIterator(name);
    }

    public HttpParams getParams() {
        return this.httpResponse.getParams();
    }

    public void setParams(HttpParams params) {
        this.httpResponse.setParams(params);
    }

    public void close() throws IOException {
        this.httpResponse.close();
    }
}

