/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.Component;
import org.codehaus.jackson.JsonNode;

public class ComponentInfo {
    private JsonNode component;

    public ComponentInfo(JsonNode root) throws ClientException {
        if (root.get("id") != null) {
            if (root.get("id") == null) {
                throw new ClientException("No Component Info returned");
            }
            this.component = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new ClientException("No Component Info returned");
            }
            this.component = root.get("data").get(0);
        }
    }

    public int getId() {
        return this.component.get("id").getIntValue();
    }

    public String getName() {
        return this.component.get("name").getTextValue();
    }

    public Component.Status getStatus() {
        return Component.Status.value(this.component.get("state").getTextValue());
    }

    public String getPid() {
        return this.component.get("pid").getTextValue();
    }
}

