/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

public class ClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int httpStatusCode = -1;

    public ClientException(String message) {
        this(message, null);
    }

    public ClientException(String message, Throwable throwable) {
        this(message, -1, throwable);
    }

    public ClientException(String message, int htmlStatusCode) {
        this(message, htmlStatusCode, null);
    }

    public ClientException(String message, int htmlStatusCode, Throwable throwable) {
        super(message, throwable);
        this.httpStatusCode = htmlStatusCode;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.httpStatusCode > -1) {
            message = message + "(return code=" + this.httpStatusCode + ")";
        }
        return message;
    }
}

