/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public class SystemPropertiesConfig {
    public static final String CONFIG_PROP_PREFIX = "sling.it.";
    public static final String HTTP_DELAY_PROP = "http.delay";
    public static final String HTTP_RETRIES_PROP = "http.retries";
    public static final String HTTP_RETRIES_DELAY_PROP = "http.retriesDelay";
    public static final String HTTP_LOG_RETRIES_PROP = "http.logRetries";
    public static final String HTTP_RETRIES_ERROR_CODES_PROP = "http.retriesErrorCodes";

    public static String getPrefixedPropertyName(String prop) {
        return CONFIG_PROP_PREFIX + prop;
    }

    public static long getHttpDelay() {
        try {
            return Long.getLong(SystemPropertiesConfig.getPrefixedPropertyName(HTTP_DELAY_PROP), 0L);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int getHttpRetries() {
        try {
            return Integer.getInteger(SystemPropertiesConfig.getPrefixedPropertyName(HTTP_RETRIES_PROP), 10);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getHttpRetriesDelay() {
        try {
            return Integer.getInteger(SystemPropertiesConfig.getPrefixedPropertyName(HTTP_RETRIES_DELAY_PROP), 1000);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isHttpLogRetries() {
        try {
            return Boolean.getBoolean(SystemPropertiesConfig.getPrefixedPropertyName(HTTP_LOG_RETRIES_PROP));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Collection<Integer> getHttpRetriesErrorCodes() {
        try {
            String errorCodes = System.getProperty(SystemPropertiesConfig.getPrefixedPropertyName(HTTP_RETRIES_ERROR_CODES_PROP), "");
            return Arrays.asList(errorCodes.split(",")).stream().map(s -> {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

