/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.Iterator;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.ComponentInfo;
import org.codehaus.jackson.JsonNode;

public class ComponentsInfo {
    private JsonNode root = null;

    public ComponentsInfo(JsonNode rootNode) throws ClientException {
        this.root = rootNode;
    }

    public int getNumberOfInstalledComponents() throws ClientException {
        if (this.root.get("status") == null) {
            throw new ClientException("Number of installed Components not defined!");
        }
        return Integer.parseInt(this.root.get("status").getValueAsText());
    }

    public ComponentInfo forId(String id) throws ClientException {
        JsonNode component = this.findBy("id", id);
        return component != null ? new ComponentInfo(component) : null;
    }

    public ComponentInfo forName(String name) throws ClientException {
        JsonNode component = this.findBy("name", name);
        return component != null ? new ComponentInfo(component) : null;
    }

    public ComponentInfo forPid(String pid) throws ClientException {
        JsonNode component = this.findBy("pid", pid);
        return component != null ? new ComponentInfo(component) : null;
    }

    private JsonNode findBy(String key, String value) {
        Iterator nodes = this.root.get("data").getElements();
        while (nodes.hasNext()) {
            String valueNode;
            JsonNode node = (JsonNode)nodes.next();
            if (null == node.get(key) || !node.get(key).isValueNode() || !(valueNode = node.get(key).getTextValue()).equals(value)) continue;
            return node;
        }
        return null;
    }
}

