/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerErrorRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServerErrorRetryStrategy.class);

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        boolean needsRetry;
        boolean bl = needsRetry = executionCount <= SystemPropertiesConfig.getHttpRetries() && this.responseRetryCondition(response);
        if (SystemPropertiesConfig.isHttpLogRetries() && needsRetry && LOG.isWarnEnabled()) {
            LOG.warn("Request retry needed due to service unavailable response");
            LOG.warn("Response headers contained:");
            Arrays.stream(response.getAllHeaders()).forEach(h -> LOG.warn("Header {}:{}", (Object)h.getName(), (Object)h.getValue()));
            try {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                LOG.warn("Response content: {}", (Object)content);
            }
            catch (IOException exc) {
                LOG.warn("Response as no content");
            }
        }
        return needsRetry;
    }

    public long getRetryInterval() {
        return SystemPropertiesConfig.getHttpRetriesDelay();
    }

    private boolean responseRetryCondition(HttpResponse response) {
        Integer statusCode = response.getStatusLine().getStatusCode();
        Collection<Integer> errorCodes = SystemPropertiesConfig.getHttpRetriesErrorCodes();
        if (errorCodes != null && !errorCodes.isEmpty()) {
            return errorCodes.contains(statusCode);
        }
        return statusCode >= 500 && statusCode < 600;
    }
}

