/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util.poller;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.timeouts.TimeoutsProvider;

public class Polling
implements Callable<Boolean> {
    protected final Callable<Boolean> c;
    protected Exception lastException;
    protected long waited;

    public Polling() {
        this.c = null;
        this.lastException = null;
        this.waited = 0L;
    }

    public Polling(Callable<Boolean> c) {
        this.c = c;
        this.lastException = null;
        this.waited = 0L;
    }

    @Override
    public Boolean call() throws Exception {
        if (this.c != null) {
            return this.c.call();
        }
        return false;
    }

    public void poll(long timeout, long delay) throws TimeoutException, InterruptedException {
        long start = System.currentTimeMillis();
        long effectiveTimeout = TimeoutsProvider.getInstance().getTimeout(timeout);
        do {
            try {
                boolean success = this.call();
                if (success) {
                    this.waited = System.currentTimeMillis() - start;
                    return;
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.lastException = e;
            }
            Thread.sleep(delay);
        } while (System.currentTimeMillis() < start + effectiveTimeout);
        this.waited = System.currentTimeMillis() - start;
        throw new TimeoutException(String.format(this.message(), effectiveTimeout, delay) + " Last exception was: " + this.lastException);
    }

    public long getWaited() {
        return this.waited;
    }

    protected String message() {
        return "Call failed to return true in %1$d ms.";
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

