/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.osgi.Bundle;
import org.apache.sling.testing.clients.osgi.BundleInfo;
import org.apache.sling.testing.clients.osgi.BundlesInfo;
import org.apache.sling.testing.clients.osgi.Component;
import org.apache.sling.testing.clients.osgi.ComponentInfo;
import org.apache.sling.testing.clients.osgi.ComponentsInfo;
import org.apache.sling.testing.clients.osgi.ServiceInfo;
import org.apache.sling.testing.clients.osgi.ServicesInfo;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.PathPoller;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiConsoleClient
extends SlingClient {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiConsoleClient.class);
    private final String CONSOLE_ROOT_URL = "/system/console";
    private final String URL_CONFIGURATION = "/system/console/configMgr";
    private final String URL_BUNDLES = "/system/console/bundles";
    private final String URL_COMPONENTS = "/system/console/components";
    private final String URL_SERVICES = "/system/console/services";
    public static final String JSON_KEY_ID = "id";
    public static final String JSON_KEY_VERSION = "version";
    public static final String JSON_KEY_DATA = "data";
    public static final String JSON_KEY_STATE = "state";

    public OsgiConsoleClient(URI serverUrl, String userName, String password) throws ClientException {
        super(serverUrl, userName, password);
    }

    public OsgiConsoleClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public BundlesInfo getBundlesInfo(int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/bundles.json", HttpUtils.getExpectedStatus(200, expectedStatus));
        return new BundlesInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public BundleInfo getBundleInfo(String id, int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/bundles/" + id + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new BundleInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public ComponentsInfo getComponentsInfo(int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/components.json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new ComponentsInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    public ComponentInfo getComponentInfo(String id, int expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/components/" + id + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new ComponentInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
    }

    private ComponentInfo getComponentInfo(String name) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/components/" + name + ".json", new int[0]);
        if (HttpUtils.getHttpStatus((HttpResponse)resp) == 200) {
            return new ComponentInfo(JsonUtils.getJsonNodeFromString(resp.getContent()));
        }
        return null;
    }

    private Collection<ServiceInfo> getServiceInfos(String type) throws ClientException {
        SlingHttpResponse resp = this.doGet("/system/console/services.json", new int[0]);
        if (HttpUtils.getHttpStatus((HttpResponse)resp) == 200) {
            return new ServicesInfo(JsonUtils.getJsonNodeFromString(resp.getContent())).forType(type);
        }
        return null;
    }

    public void waitComponentRegistered(final String componentName, long timeout, long delay) throws TimeoutException, InterruptedException {
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                ComponentInfo info = OsgiConsoleClient.this.getComponentInfo(componentName);
                if (info != null) {
                    return info.getStatus() == Component.Status.SATISFIED || info.getStatus() == Component.Status.ACTIVE;
                }
                LOG.debug("Could not get component info for component name {}", (Object)componentName);
                return false;
            }

            @Override
            protected String message() {
                return "Component " + componentName + " was not registered in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public void waitServiceRegistered(final String type, final String bundleSymbolicName, long timeout, long delay) throws TimeoutException, InterruptedException {
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                Collection infos = OsgiConsoleClient.this.getServiceInfos(type);
                if (infos != null) {
                    if (bundleSymbolicName != null) {
                        for (ServiceInfo info : infos) {
                            if (!bundleSymbolicName.equals(info.getBundleSymbolicName())) continue;
                            return true;
                        }
                        LOG.debug("Could not find service info for service type {} provided by bundle {}", (Object)type, (Object)bundleSymbolicName);
                        return false;
                    }
                    return !infos.isEmpty();
                }
                LOG.debug("Could not find any service info for service type {}", (Object)type);
                return false;
            }

            @Override
            protected String message() {
                return "Service with type " + type + " was not registered in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public Map<String, Object> getConfiguration(String pid, int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + pid, null, new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(resp.getContent());
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (rootNode.get("properties") == null) {
            return props;
        }
        JsonNode properties = rootNode.get("properties");
        Iterator it = properties.getFieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            JsonNode value = properties.get(propName).get("value");
            if (value != null) {
                props.put(propName, value.getValueAsText());
                continue;
            }
            value = properties.get(propName).get("values");
            if (value == null) continue;
            Iterator iter = value.getElements();
            ArrayList<String> list = new ArrayList<String>();
            while (iter.hasNext()) {
                list.add(((JsonNode)iter.next()).getValueAsText());
            }
            props.put(propName, list.toArray(new String[list.size()]));
        }
        return props;
    }

    public Map<String, Object> getOSGiConfiguration(String pid, int ... expectedStatus) throws ClientException {
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + pid, null, new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(resp.getContent());
        return OsgiConsoleClient.extractOSGiConfiguration(rootNode);
    }

    static Map<String, Object> extractOSGiConfiguration(JsonNode rootNode) {
        if (rootNode.get("bundle_location") == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonNode propertiesNode = rootNode.get("properties");
        if (propertiesNode != null) {
            Iterator it = propertiesNode.getFieldNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                JsonNode propNode = propertiesNode.get(propName);
                boolean isSet = propNode.get("is_set").getBooleanValue();
                if (!isSet) continue;
                JsonNode value = propNode.get("value");
                if (value != null) {
                    result.put(propName, value.getValueAsText());
                    continue;
                }
                value = propNode.get("values");
                if (value == null) continue;
                Iterator iter = value.getElements();
                ArrayList<String> list = new ArrayList<String>();
                while (iter.hasNext()) {
                    list.add(((JsonNode)iter.next()).getValueAsText());
                }
                result.put(propName, list.toArray(new String[list.size()]));
            }
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> getConfigurationWithWait(long waitCount, String pid, int ... expectedStatus) throws ClientException, InterruptedException {
        ConfigurationPoller poller = new ConfigurationPoller(pid, expectedStatus);
        try {
            poller.poll(500L * waitCount, 500L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Cannot retrieve configuration.", e);
        }
        return poller.getConfig();
    }

    public Map<String, Object> waitGetConfiguration(long timeout, String pid, int ... expectedStatus) throws ClientException, InterruptedException, TimeoutException {
        ConfigurationPoller poller = new ConfigurationPoller(pid, expectedStatus);
        poller.poll(timeout, 500L);
        return poller.getConfig();
    }

    public String editConfiguration(String PID, String factoryPID, Map<String, Object> configProperties, int ... expectedStatus) throws ClientException {
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("apply", "true");
        builder.addParameter("action", "ajaxConfigManager");
        if (factoryPID != null) {
            builder.addParameter("factoryPid", factoryPID);
        }
        StringBuilder propertyList = new StringBuilder("");
        for (String propName : configProperties.keySet()) {
            Object o = configProperties.get(propName);
            if (o instanceof String) {
                builder.addParameter(propName, (String)o);
            } else if (o instanceof String[]) {
                for (String s : (String[])o) {
                    builder.addParameter(propName, s);
                }
            }
            propertyList.append(propName).append(",");
        }
        builder.addParameter("propertylist", propertyList.substring(0, propertyList.length() - 1));
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + PID, (HttpEntity)builder.build(), new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(302, expectedStatus));
        Header[] locationHeader = resp.getHeaders("Location");
        if (locationHeader != null && locationHeader.length == 1) {
            int urlPathStart = locationHeader[0].getValue().indexOf("/system/console/configMgr");
            return locationHeader[0].getValue().substring(urlPathStart + "/system/console/configMgr".length() + 1);
        }
        return null;
    }

    @Deprecated
    public String editConfigurationWithWait(int waitCount, String PID, String factoryPID, Map<String, Object> configProperties, int ... expectedStatus) throws ClientException, InterruptedException {
        String pid = this.editConfiguration(PID, factoryPID, configProperties, expectedStatus);
        this.getConfigurationWithWait(waitCount, pid, new int[0]);
        return pid;
    }

    public String waitEditConfiguration(long timeout, String PID, String factoryPID, Map<String, Object> configProperties, int ... expectedStatus) throws ClientException, InterruptedException, TimeoutException {
        String pid = this.editConfiguration(PID, factoryPID, configProperties, expectedStatus);
        this.waitGetConfiguration(timeout, pid, new int[0]);
        return pid;
    }

    public SlingHttpResponse deleteConfiguration(String pid, int ... expectedStatus) throws ClientException {
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("apply", "1");
        builder.addParameter("delete", "1");
        SlingHttpResponse resp = this.doPost("/system/console/configMgr/" + pid, (HttpEntity)builder.build(), new int[0]);
        HttpUtils.verifyHttpStatus(resp, HttpUtils.getExpectedStatus(200, expectedStatus));
        return resp;
    }

    public SlingHttpResponse uninstallBundle(String symbolicName) throws ClientException {
        long bundleId = this.getBundleId(symbolicName);
        LOG.info("Uninstalling bundle {} with bundleId {}", (Object)symbolicName, (Object)bundleId);
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("action", "uninstall");
        return this.doPost(this.getBundlePath(symbolicName), (HttpEntity)builder.build(), 200);
    }

    public SlingHttpResponse installBundle(File f, boolean startBundle) throws ClientException {
        return this.installBundle(f, startBundle, 0);
    }

    public SlingHttpResponse installBundle(File f, boolean startBundle, int startLevel) throws ClientException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addTextBody("action", "install").addBinaryBody("bundlefile", f);
        if (startBundle) {
            builder.addTextBody("bundlestart", "true");
        }
        if (startLevel > 0) {
            builder.addTextBody("bundlestartlevel", String.valueOf(startLevel));
            LOG.info("Installing bundle {} at start level {}", (Object)f.getName(), (Object)startLevel);
        } else {
            LOG.info("Installing bundle {} at default start level", (Object)f.getName());
        }
        return this.doPost("/system/console/bundles", builder.build(), 302);
    }

    @Deprecated
    public boolean checkBundleInstalled(String symbolicName, int waitTime, int retries) throws InterruptedException {
        String path = this.getBundlePath(symbolicName, ".json");
        return new PathPoller(this, path, waitTime, retries, new int[0]).callAndWait();
    }

    @Deprecated
    public boolean installBundleWithRetry(File f, boolean startBundle, int startLevel, int waitTime, int retries) throws ClientException, InterruptedException {
        this.installBundle(f, startBundle, startLevel);
        try {
            return this.checkBundleInstalled(OsgiConsoleClient.getBundleSymbolicName(f), waitTime, retries);
        }
        catch (IOException e) {
            throw new ClientException("Cannot get bundle symbolic name", e);
        }
    }

    public void waitInstallBundle(File f, boolean startBundle, int startLevel, long timeout, long delay) throws ClientException, InterruptedException, TimeoutException {
        this.installBundle(f, startBundle, startLevel);
        try {
            this.waitBundleInstalled(OsgiConsoleClient.getBundleSymbolicName(f), timeout, delay);
        }
        catch (IOException e) {
            throw new ClientException("Cannot get bundle symbolic name", e);
        }
    }

    public void waitBundleInstalled(final String symbolicName, long timeout, long delay) throws TimeoutException, InterruptedException {
        final String path = this.getBundlePath(symbolicName);
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                return OsgiConsoleClient.this.exists(path);
            }

            @Override
            protected String message() {
                return "Bundle " + symbolicName + " did not install in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public void waitBundleStarted(final String symbolicName, long timeout, long delay) throws TimeoutException, InterruptedException {
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                try {
                    BundleInfo bundleInfo = OsgiConsoleClient.this.getBundleInfo(symbolicName, 200);
                    return bundleInfo.getStatus() == Bundle.Status.ACTIVE;
                }
                catch (ClientException e) {
                    LOG.debug("Could not get bundle state for {}: {}", new Object[]{symbolicName, e.getLocalizedMessage(), e});
                    return false;
                }
            }

            @Override
            protected String message() {
                return "Bundle " + symbolicName + " did not start in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public long getBundleId(String symbolicName) throws ClientException {
        JsonNode bundle = this.getBundleData(symbolicName);
        JsonNode idNode = bundle.get(JSON_KEY_ID);
        if (idNode == null) {
            throw new ClientException("Cannot get id from bundle json");
        }
        return idNode.getLongValue();
    }

    public String getBundleVersion(String symbolicName) throws ClientException {
        JsonNode bundle = this.getBundleData(symbolicName);
        JsonNode versionNode = bundle.get(JSON_KEY_VERSION);
        if (versionNode == null) {
            throw new ClientException("Cannot get version from bundle json");
        }
        return versionNode.getTextValue();
    }

    public String getBundleState(String symbolicName) throws ClientException {
        JsonNode bundle = this.getBundleData(symbolicName);
        JsonNode stateNode = bundle.get(JSON_KEY_STATE);
        if (stateNode == null) {
            throw new ClientException("Cannot get state from bundle json");
        }
        return stateNode.getTextValue();
    }

    public void startBundle(String symbolicName) throws ClientException {
        String path = this.getBundlePath(symbolicName);
        LOG.info("Starting bundle {} via {}", (Object)symbolicName, (Object)path);
        this.doPost(path, (HttpEntity)FormEntityBuilder.create().addParameter("action", "start").build(), 200);
    }

    public void stopBundle(String symbolicName) throws ClientException {
        String path = this.getBundlePath(symbolicName);
        LOG.info("Stopping bundle {} via {}", (Object)symbolicName, (Object)path);
        this.doPost(path, (HttpEntity)FormEntityBuilder.create().addParameter("action", "stop").build(), 200);
    }

    @Deprecated
    public void startBundlewithWait(String symbolicName, int waitTime, int retries) throws ClientException, InterruptedException {
        this.startBundle(symbolicName);
        this.checkBundleInstalled(symbolicName, waitTime, retries);
    }

    public void waitStartBundle(String symbolicName, long timeout, long delay) throws ClientException, InterruptedException, TimeoutException {
        this.startBundle(symbolicName);
        this.waitBundleInstalled(symbolicName, timeout, delay);
    }

    public void refreshPackages() throws ClientException {
        LOG.info("Refreshing packages.");
        FormEntityBuilder builder = FormEntityBuilder.create();
        builder.addParameter("action", "refreshPackages");
        this.doPost("/system/console/bundles", (HttpEntity)builder.build(), 200);
    }

    private String getBundlePath(String symbolicName, String extension) {
        return this.getBundlePath(symbolicName) + extension;
    }

    private String getBundlePath(String symbolicName) {
        return "/system/console/bundles/" + symbolicName;
    }

    private JsonNode getBundleData(String symbolicName) throws ClientException {
        String path = this.getBundlePath(symbolicName, ".json");
        String content = this.doGet(path, 200).getContent();
        JsonNode root = JsonUtils.getJsonNodeFromString(content);
        if (root.get(JSON_KEY_DATA) == null) {
            throw new ClientException(path + " does not provide '" + JSON_KEY_DATA + "' element, JSON content=" + content);
        }
        Iterator data = root.get(JSON_KEY_DATA).getElements();
        if (!data.hasNext()) {
            throw new ClientException(path + "." + JSON_KEY_DATA + " is empty, JSON content=" + content);
        }
        JsonNode bundle = (JsonNode)data.next();
        if (bundle.get(JSON_KEY_STATE) == null) {
            throw new ClientException(path + ".data[0].state missing, JSON content=" + content);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleSymbolicName(File bundleFile) throws IOException {
        String name = null;
        try (JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));){
            Manifest m = jis.getManifest();
            if (m == null) {
                throw new IOException("Manifest is null in " + bundleFile.getAbsolutePath());
            }
            name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleVersionFromFile(File bundleFile) throws IOException {
        String version = null;
        try (JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));){
            Manifest m = jis.getManifest();
            if (m == null) {
                throw new IOException("Manifest is null in " + bundleFile.getAbsolutePath());
            }
            version = m.getMainAttributes().getValue("Bundle-Version");
        }
        return version;
    }

    class ConfigurationPoller
    extends Polling {
        private final String pid;
        private final int[] expectedStatus;
        private Map<String, Object> config;

        public ConfigurationPoller(String pid, int ... expectedStatus) {
            this.pid = pid;
            this.expectedStatus = expectedStatus;
            this.config = null;
        }

        @Override
        public Boolean call() throws Exception {
            this.config = OsgiConsoleClient.this.getConfiguration(this.pid, this.expectedStatus);
            return this.config != null;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }
    }
}

