/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.List;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.ServicesInfo;
import org.codehaus.jackson.JsonNode;

public class ServiceInfo {
    private JsonNode service;

    public ServiceInfo(JsonNode root) throws ClientException {
        if (root.get("id") != null) {
            this.service = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new ClientException("No service info returned");
            }
            this.service = root.get("data").get(0);
        }
    }

    public int getId() {
        return Integer.parseInt(this.service.get("id").getValueAsText());
    }

    public List<String> getTypes() {
        return ServicesInfo.splitPseudoJsonValueArray(this.service.get("types").getTextValue());
    }

    public String getPid() {
        return this.service.get("pid").getTextValue();
    }

    public int getBundleId() {
        return this.service.get("bundleId").getIntValue();
    }

    public String getBundleSymbolicName() {
        return this.service.get("bundleSymbolicName").getTextValue();
    }
}

