/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.apache.sling.testing.clients.interceptors.DelayRequestInterceptor;
import org.apache.sling.testing.clients.interceptors.TestDescriptionInterceptor;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.ServerErrorRetryStrategy;
import org.apache.sling.testing.clients.util.poller.AbstractPoller;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.codehaus.jackson.JsonNode;

@Immutable
public class SlingClient
extends AbstractSlingClient {
    public static final String DEFAULT_NODE_TYPE = "sling:OrderedFolder";

    public SlingClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public SlingClient(URI url, String user, String password) throws ClientException {
        super(Builder.create(url, user, password).buildHttpClient(), Builder.create(url, user, password).buildSlingClientConfig());
    }

    public SlingHttpResponse move(String srcPath, String destPath, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":operation", "move").addParameter(":dest", destPath).build();
        return this.doPost(srcPath, (HttpEntity)entity, expectedStatus);
    }

    public SlingHttpResponse deletePath(String path, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":operation", "delete").build();
        return this.doPost(path, (HttpEntity)entity, expectedStatus);
    }

    public SlingHttpResponse createNodeRecursive(String path, String nodeType) throws ClientException {
        String parentPath = this.getParentPath(path);
        if (!parentPath.isEmpty() && !this.exists(parentPath)) {
            this.createNodeRecursive(parentPath, nodeType);
        }
        return this.createNode(path, nodeType);
    }

    public SlingHttpResponse createNode(String path, String nodeType) throws ClientException {
        if (!this.exists(path)) {
            String nodeTypeValue = nodeType;
            if (nodeTypeValue == null) {
                nodeTypeValue = DEFAULT_NODE_TYPE;
            }
            String nodeName = this.getNodeNameFromPath(path);
            String nodeParentPath = this.getParentPath(path);
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(nodeName + "/jcr:primaryType", nodeTypeValue).build();
            return this.doPost(nodeParentPath, (HttpEntity)entity, 200, 201);
        }
        return null;
    }

    public boolean exists(String path) throws ClientException {
        SlingHttpResponse response = this.doGet(path + ".json", new int[0]);
        int status = response.getStatusLine().getStatusCode();
        return status == 200;
    }

    protected String getParentPath(String path) {
        String normalizedPath = StringUtils.removeEnd((String)path, (String)"/");
        return StringUtils.substringBeforeLast((String)normalizedPath, (String)"/");
    }

    protected String getNodeNameFromPath(String path) {
        String normalizedPath = StringUtils.removeEnd((String)path, (String)"/");
        int pos = normalizedPath.lastIndexOf(47);
        if (pos != -1) {
            return normalizedPath.substring(pos + 1, normalizedPath.length());
        }
        return normalizedPath;
    }

    @Deprecated
    public void waitUntilExists(final String path, long waitMillis, int retryCount) throws ClientException, InterruptedException {
        AbstractPoller poller = new AbstractPoller(waitMillis, retryCount){
            boolean found;
            {
                super(waitInterval, waitCount);
                this.found = false;
            }

            @Override
            public boolean call() {
                try {
                    this.found = SlingClient.this.exists(path);
                }
                catch (ClientException e) {
                    this.found = false;
                }
                return true;
            }

            @Override
            public boolean condition() {
                return this.found;
            }
        };
        boolean found = poller.callUntilCondition();
        if (!found) {
            throw new ClientException("path " + path + " does not exist after " + retryCount + " retries");
        }
    }

    public void waitExists(final String path, long timeout, long delay) throws TimeoutException, InterruptedException {
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                return SlingClient.this.exists(path);
            }

            @Override
            protected String message() {
                return "Path " + path + " does not exist after %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public SlingHttpResponse setPropertyString(String nodePath, String propName, String propValue, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity formEntry = FormEntityBuilder.create().addParameter(propName, propValue).build();
        return this.doPost(nodePath, (HttpEntity)formEntry, HttpUtils.getExpectedStatus(200, expectedStatus));
    }

    public SlingHttpResponse setPropertyStringArray(String nodePath, String propName, List<String> propValueList, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        for (String propValue : propValueList != null ? propValueList : new ArrayList(0)) {
            formEntry.addParameter(propName, propValue);
        }
        return this.doPost(nodePath, (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus(200, expectedStatus));
    }

    public SlingHttpResponse setPropertiesString(String nodePath, List<NameValuePair> properties, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity formEntry = FormEntityBuilder.create().addAllParameters(properties).build();
        return this.doPost(nodePath, (HttpEntity)formEntry, HttpUtils.getExpectedStatus(200, expectedStatus));
    }

    @Deprecated
    public JsonNode getJsonNode(String path, int depth) throws ClientException, InterruptedException {
        return this.getJsonNode(path, depth, 500L, 20, new int[0]);
    }

    @Deprecated
    public JsonNode getJsonNode(String path, int depth, long waitMillis, int retryNumber, int ... expectedStatus) throws ClientException, InterruptedException {
        this.waitUntilExists(path, waitMillis, retryNumber);
        path = depth == -1 ? path + ".infinity.json" : path + "." + depth + ".json";
        SlingHttpResponse response = this.doGet(path, new int[0]);
        HttpUtils.verifyHttpStatus(response, HttpUtils.getExpectedStatus(200, expectedStatus));
        return JsonUtils.getJsonNodeFromString(response.getContent());
    }

    public JsonNode doGetJson(String path, int depth, int ... expectedStatus) throws ClientException {
        path = depth == -1 ? path + ".infinity.json" : path + "." + depth + ".json";
        SlingHttpResponse response = this.doGet(path, HttpUtils.getExpectedStatus(200, expectedStatus));
        return JsonUtils.getJsonNodeFromString(response.getContent());
    }

    public SlingHttpResponse upload(File file, String mimeType, String toPath, boolean createFolders, int ... expectedStatus) throws ClientException {
        String toFolder;
        String toFileName;
        if (toPath.endsWith("/")) {
            toFileName = file.getName();
            toFolder = toPath;
        } else {
            toFileName = this.getNodeNameFromPath(toPath);
            toFolder = this.getParentPath(toPath);
        }
        if (createFolders) {
            this.createNodeRecursive(toFolder, DEFAULT_NODE_TYPE);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody(toFileName, file, ContentType.create((String)mimeType), toFileName).build();
        return this.doPost(toFolder, entity, HttpUtils.getExpectedStatus(201, expectedStatus));
    }

    public SlingHttpResponse createFolder(String folderName, String folderTitle, String parentPath, int ... expectedStatus) throws ClientException {
        parentPath = StringUtils.appendIfMissing((String)parentPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String folderPath = parentPath + folderName;
        UrlEncodedFormEntity feb = FormEntityBuilder.create().addParameter("./jcr:primaryType", DEFAULT_NODE_TYPE).addParameter("./jcr:content/jcr:primaryType", "nt:unstructured").addParameter("./jcr:content/jcr:title", folderTitle).build();
        return this.doPost(folderPath, (HttpEntity)feb, HttpUtils.getExpectedStatus(201, expectedStatus));
    }

    public SlingHttpResponse importContent(String parentPath, String contentType, String content, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":operation", "import").addParameter(":contentType", contentType).addParameter(":content", content).build();
        return this.doPost(parentPath, (HttpEntity)entity, HttpUtils.getExpectedStatus(201, expectedStatus));
    }

    public SlingHttpResponse importContent(String parentPath, String contentType, File contentFile, int ... expectedStatus) throws ClientException {
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody(":operation", "import").addTextBody(":contentType", contentType).addBinaryBody(":contentFile", contentFile).build();
        return this.doPost(parentPath, entity, HttpUtils.getExpectedStatus(201, expectedStatus));
    }

    public SlingHttpResponse importJson(String parentPath, JsonNode json, int ... expectedStatus) throws ClientException {
        return this.importContent(parentPath, "json", json.toString(), expectedStatus);
    }

    public String getUUID(String path) throws ClientException {
        if (!this.exists(path)) {
            return null;
        }
        JsonNode jsonNode = this.doGetJson(path, -1, new int[0]);
        return this.getUUId(jsonNode);
    }

    public String getUUId(JsonNode jsonNode) throws ClientException {
        if (jsonNode == null) {
            return null;
        }
        JsonNode uuidNode = jsonNode.get("jcr:uuid");
        if (uuidNode == null) {
            return null;
        }
        return uuidNode.getValueAsText();
    }

    public static final class Builder
    extends InternalBuilder<SlingClient> {
        private Builder(URI url, String user, String password) {
            super(url, user, password);
        }

        @Override
        public SlingClient build() throws ClientException {
            return new SlingClient(this.buildHttpClient(), this.buildSlingClientConfig());
        }

        public static Builder create(URI url, String user, String password) {
            return new Builder(url, user, password);
        }
    }

    public static abstract class InternalBuilder<T extends SlingClient> {
        private final SlingClientConfig.Builder configBuilder;
        private final HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();

        protected InternalBuilder(URI url, String user, String password) {
            this.configBuilder = SlingClientConfig.Builder.create().setUrl(url).setUser(user).setPassword(password);
            this.setDefaults();
        }

        public InternalBuilder<T> setUrl(URI url) {
            this.configBuilder.setUrl(url);
            return this;
        }

        public InternalBuilder<T> setUser(String user) {
            this.configBuilder.setUser(user);
            return this;
        }

        public InternalBuilder<T> setPassword(String password) {
            this.configBuilder.setPassword(password);
            return this;
        }

        public InternalBuilder<T> setCredentialsProvider(CredentialsProvider cp) {
            this.configBuilder.setCredentialsProvider(cp);
            return this;
        }

        public InternalBuilder<T> setPreemptiveAuth(boolean isPreemptiveAuth) {
            this.configBuilder.setPreemptiveAuth(isPreemptiveAuth);
            return this;
        }

        public InternalBuilder<T> setCookieStore(CookieStore cs) {
            this.configBuilder.setCookieStore(cs);
            return this;
        }

        public HttpClientBuilder httpClientBuilder() {
            return this.httpClientBuilder;
        }

        public abstract T build() throws ClientException;

        protected CloseableHttpClient buildHttpClient() {
            return this.httpClientBuilder.build();
        }

        protected SlingClientConfig buildSlingClientConfig() throws ClientException {
            return this.configBuilder.build();
        }

        private InternalBuilder setDefaults() {
            this.httpClientBuilder.useSystemProperties();
            this.httpClientBuilder.setUserAgent("Java");
            this.httpClientBuilder.setMaxConnPerRoute(10);
            this.httpClientBuilder.setMaxConnTotal(100);
            this.httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new TestDescriptionInterceptor());
            this.httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new DelayRequestInterceptor(SystemPropertiesConfig.getHttpDelay()));
            this.httpClientBuilder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new ServerErrorRetryStrategy());
            return this;
        }

        public final InternalBuilder<T> addInterceptorFirst(HttpResponseInterceptor itcp) {
            this.httpClientBuilder.addInterceptorFirst(itcp);
            return this;
        }

        public final InternalBuilder<T> addInterceptorLast(HttpResponseInterceptor itcp) {
            this.httpClientBuilder.addInterceptorLast(itcp);
            return this;
        }

        public final InternalBuilder<T> addInterceptorFirst(HttpRequestInterceptor itcp) {
            this.httpClientBuilder.addInterceptorFirst(itcp);
            return this;
        }

        public final InternalBuilder<T> addInterceptorLast(HttpRequestInterceptor itcp) {
            this.httpClientBuilder.addInterceptorLast(itcp);
            return this;
        }

        public final InternalBuilder<T> setRedirectStrategy(RedirectStrategy redirectStrategy) {
            this.httpClientBuilder.setRedirectStrategy(redirectStrategy);
            return this;
        }

        public final InternalBuilder<T> disableRedirectHandling() {
            this.httpClientBuilder.disableRedirectHandling();
            return this;
        }
    }
}

