/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.Bundle;
import org.apache.sling.testing.clients.osgi.BundleInfo;

public class BundlesInfo {
    private JsonNode root = null;
    private JsonNode status = null;

    public BundlesInfo(JsonNode root) throws ClientException {
        this.root = root;
        if (root.get("s") == null) {
            throw new ClientException("No Status Info returned!");
        }
        if (root.get("s").size() != 5) {
            throw new ClientException("Wrong number of status numbers listed!");
        }
        this.status = root.get("s");
    }

    public String getStatusMessage() throws ClientException {
        if (this.root.get("status") == null) {
            throw new ClientException("No Status message returned!");
        }
        return this.root.get("status").asText();
    }

    public int getTotalNumOfBundles() {
        return Integer.parseInt(this.status.get(0).asText());
    }

    public int getNumBundlesByStatus(Bundle.Status status) {
        int index = -1;
        switch (status) {
            case ACTIVE: {
                index = 1;
                break;
            }
            case FRAGMENT: {
                index = 2;
                break;
            }
            case RESOLVED: {
                index = 3;
                break;
            }
            case INSTALLED: {
                index = 4;
            }
        }
        return Integer.parseInt(this.status.get(index).asText());
    }

    public BundleInfo forId(String id) throws ClientException {
        JsonNode bundle = this.findBy("id", id);
        return bundle != null ? new BundleInfo(bundle) : null;
    }

    public BundleInfo forName(String name) throws ClientException {
        JsonNode bundle = this.findBy("name", name);
        return bundle != null ? new BundleInfo(bundle) : null;
    }

    public BundleInfo forSymbolicName(String name) throws ClientException {
        JsonNode bundle = this.findBy("symbolicName", name);
        return bundle != null ? new BundleInfo(bundle) : null;
    }

    private JsonNode findBy(String key, String value) {
        Iterator nodes = this.root.get("data").elements();
        while (nodes.hasNext()) {
            String valueNode;
            JsonNode node = (JsonNode)nodes.next();
            if (null == node.get(key) || !node.get(key).isValueNode() || !(valueNode = node.get(key).textValue()).equals(value)) continue;
            return node;
        }
        return null;
    }
}

