/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.Component;

public class ComponentInfo {
    private JsonNode component;

    public ComponentInfo(JsonNode root) throws ClientException {
        if (root.get("id") != null) {
            if (root.get("id") == null) {
                throw new ClientException("No Component Info returned");
            }
            this.component = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new ClientException("No Component Info returned");
            }
            this.component = root.get("data").get(0);
        }
    }

    public int getId() {
        return this.component.get("id").intValue();
    }

    public String getName() {
        return this.component.get("name").textValue();
    }

    public Component.Status getStatus() {
        return Component.Status.value(this.component.get("state").textValue());
    }

    public String getPid() {
        return this.component.get("pid").textValue();
    }
}

