/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.testing.clients.interceptors.TestDescriptionHolder;

public class TestDescriptionInterceptor
implements HttpRequestInterceptor {
    public static final String TEST_CLASS_HEADER = "X-Sling-TestClass";
    public static final String TEST_NAME_HEADER = "X-Sling-TestName";

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        TestDescriptionInterceptor.addHeader(httpRequest, TEST_NAME_HEADER, TestDescriptionHolder.getMethodName());
        TestDescriptionInterceptor.addHeader(httpRequest, TEST_CLASS_HEADER, TestDescriptionHolder.getClassName());
    }

    private static void addHeader(HttpRequest httpRequest, String name, String value) {
        if (value != null) {
            httpRequest.addHeader(name, value);
        }
    }
}

