/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.MockQuery;
import org.apache.sling.testing.mock.jcr.MockQueryResult;
import org.apache.sling.testing.mock.jcr.MockQueryResultHandler;

class MockQueryManager
implements QueryManager {
    private List<MockQueryResultHandler> resultHandlers = new ArrayList<MockQueryResultHandler>();
    private static final List<String> SUPPORTED_QUERY_LANGUAGES = ImmutableList.of((Object)"JCR-SQL2", (Object)"JCR-JQOM", (Object)"xpath", (Object)"sql");

    MockQueryManager() {
    }

    public Query createQuery(String statement, String language) throws RepositoryException {
        if (!SUPPORTED_QUERY_LANGUAGES.contains(StringUtils.defaultString((String)language))) {
            throw new InvalidQueryException("Unsupported query language: " + language);
        }
        return new MockQuery(this, statement, language);
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return SUPPORTED_QUERY_LANGUAGES.toArray(new String[SUPPORTED_QUERY_LANGUAGES.size()]);
    }

    void addResultHandler(MockQueryResultHandler resultHandler) {
        this.resultHandlers.add(resultHandler);
    }

    QueryResult executeQuery(MockQuery query) {
        for (MockQueryResultHandler resultHandler : this.resultHandlers) {
            MockQueryResult result = resultHandler.executeQuery(query);
            if (result == null) continue;
            return result;
        }
        return new MockQueryResult((List<Node>)ImmutableList.of());
    }

    public QueryObjectModelFactory getQOMFactory() {
        throw new UnsupportedOperationException();
    }

    public Query getQuery(Node node) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

