/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import aQute.bnd.annotation.ProviderType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.sling.testing.mock.jcr.MockRow;

@ProviderType
public final class MockQueryResult
implements QueryResult {
    private final List<Node> nodes;
    private final List<String> columnNames;

    public MockQueryResult(List<Node> nodes) {
        this(nodes, (List<String>)ImmutableList.of());
    }

    public MockQueryResult(List<Node> nodes, List<String> columnNames) {
        this.columnNames = columnNames;
        this.nodes = nodes;
    }

    public String[] getColumnNames() throws RepositoryException {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorAdapter((Collection)Lists.transform(this.nodes, (Function)new Function<Node, Row>(){

            public Row apply(Node node) {
                return new MockRow(MockQueryResult.this.columnNames, node);
            }
        }));
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new NodeIteratorAdapter(this.nodes);
    }

    public String[] getSelectorNames() throws RepositoryException {
        return new String[0];
    }
}

