/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.ItemFilter;
import org.apache.sling.testing.mock.jcr.MockNode;
import org.apache.sling.testing.mock.jcr.MockProperty;
import org.apache.sling.testing.mock.jcr.MockRepository;
import org.apache.sling.testing.mock.jcr.MockWorkspace;
import org.apache.sling.testing.mock.jcr.ResourceUtil;
import org.xml.sax.ContentHandler;

class MockSession
implements Session {
    private final MockRepository repository;
    private final Workspace workspace;
    private final Map<String, ItemData> items;
    private final String userId;

    public MockSession(MockRepository repository, Map<String, ItemData> items, String userId, String workspaceName) {
        this.repository = repository;
        this.workspace = new MockWorkspace(repository, this, workspaceName);
        this.items = items;
        this.userId = userId;
    }

    public ValueFactory getValueFactory() throws RepositoryException {
        return ValueFactoryImpl.getInstance();
    }

    public Item getItem(String absPath) throws RepositoryException {
        ItemData itemData = this.getItemData(absPath);
        if (itemData != null) {
            if (itemData.isNode()) {
                return new MockNode(itemData, this);
            }
            return new MockProperty(itemData, this);
        }
        throw new PathNotFoundException(String.format("No item found at: %s.", absPath));
    }

    public Node getNode(String absPath) throws RepositoryException {
        Item item = this.getItem(absPath);
        if (item instanceof Node) {
            return (Node)item;
        }
        throw new PathNotFoundException(String.format("No node found at: %s.", absPath));
    }

    public Node getNodeByIdentifier(String id) throws RepositoryException {
        for (ItemData item : this.items.values()) {
            if (!item.isNode() || !StringUtils.equals((CharSequence)item.getUuid(), (CharSequence)id)) continue;
            return new MockNode(item, this);
        }
        throw new ItemNotFoundException(String.format("No node found with id: %s.", id));
    }

    public Property getProperty(String absPath) throws RepositoryException {
        Item item = this.getItem(absPath);
        if (item instanceof Property) {
            return (Property)item;
        }
        throw new PathNotFoundException(String.format("No property found at: %s.", absPath));
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath) && this.getItemData(absPath).isNode();
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath) && this.getItemData(absPath).isProperty();
    }

    public void removeItem(String absPath) throws RepositoryException {
        this.removeItemWithChildren(absPath);
    }

    public Node getRootNode() throws RepositoryException {
        return this.getNode("/");
    }

    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.getNodeByIdentifier(uuid);
    }

    void addItem(ItemData itemData) {
        this.items.put(itemData.getPath(), itemData);
    }

    private ItemData getItemData(String absPath) {
        String normalizedPath = ResourceUtil.normalize(absPath);
        return this.items.get(normalizedPath);
    }

    private void removeItemWithChildren(String absPath) throws RepositoryException {
        if (!this.itemExists(absPath)) {
            return;
        }
        ItemData parent = this.getItemData(absPath);
        String descendantPrefix = parent.getPath() + "/";
        ArrayList<String> pathsToRemove = new ArrayList<String>();
        pathsToRemove.add(parent.getPath());
        for (String itemPath : this.items.keySet()) {
            if (!itemPath.startsWith(descendantPrefix)) continue;
            pathsToRemove.add(itemPath);
        }
        for (String pathToRemove : pathsToRemove) {
            this.items.remove(pathToRemove);
        }
    }

    RangeIterator listChildren(String parentPath, ItemFilter filter) throws RepositoryException {
        ArrayList<Item> children = new ArrayList<Item>();
        Pattern pattern = Pattern.compile("^" + Pattern.quote(parentPath) + "/[^/]+$");
        for (ItemData item : this.items.values()) {
            if (!pattern.matcher(item.getPath()).matches() || filter != null && !filter.accept(item)) continue;
            children.add(item.getItem(this));
        }
        return new RangeIteratorAdapter(children.iterator(), (long)children.size());
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return false;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.getItemData(absPath) != null;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String getUserID() {
        return this.userId;
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.getWorkspace().getNamespaceRegistry().getPrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.getWorkspace().getNamespaceRegistry().getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void save() throws RepositoryException {
        for (ItemData itemData : this.items.values()) {
            itemData.setIsNew(false);
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
    }

    public void checkPermission(String absPath, String actions) throws RepositoryException {
    }

    public void addLockToken(String lt) {
        throw new UnsupportedOperationException();
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getLockTokens() {
        throw new UnsupportedOperationException();
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isLive() {
        throw new UnsupportedOperationException();
    }

    public void logout() {
        throw new UnsupportedOperationException();
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLockToken(String lt) {
        throw new UnsupportedOperationException();
    }

    public AccessControlManager getAccessControlManager() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

