/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.sling.testing.mock.jcr.AbstractItem;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.ItemFilter;
import org.apache.sling.testing.mock.jcr.MockNodeType;
import org.apache.sling.testing.mock.jcr.MockProperty;

class MockNode
extends AbstractItem
implements Node {
    public MockNode(ItemData itemData, Session session) {
        super(itemData, session);
    }

    public Node addNode(String relPath) throws RepositoryException {
        return this.addNode(relPath, "nt:unstructured");
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        ItemData itemData = ItemData.newNode(path, new MockNodeType(primaryNodeTypeName));
        MockNode node = new MockNode(itemData, this.getSession());
        this.getMockedSession().addItem(itemData);
        node.setProperty("jcr:primaryType", primaryNodeTypeName);
        if (StringUtils.equals((CharSequence)primaryNodeTypeName, (CharSequence)"nt:file")) {
            node.setProperty("jcr:created", Calendar.getInstance());
            node.setProperty("jcr:createdBy", this.getMockedSession().getUserID());
        }
        return node;
    }

    public Node getNode(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().getNode(path);
    }

    public NodeIterator getNodes() throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isNode();
            }
        });
        return new NodeIteratorAdapter((Iterator)items, items.getSize());
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        final Pattern pattern = Pattern.compile(namePattern);
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isNode() && pattern.matcher(item.getName()).matches();
            }
        });
        return new NodeIteratorAdapter((Iterator)items, items.getSize());
    }

    public PropertyIterator getProperties() throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isProperty();
            }
        });
        return new PropertyIteratorAdapter((Iterator)items, items.getSize());
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        final Pattern pattern = Pattern.compile(namePattern);
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isProperty() && pattern.matcher(item.getName()).matches();
            }
        });
        return new PropertyIteratorAdapter((Iterator)items, items.getSize());
    }

    public Property getProperty(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().getProperty(path);
    }

    public String getIdentifier() throws RepositoryException {
        return this.itemData.getUuid();
    }

    public String getUUID() throws RepositoryException {
        return this.getIdentifier();
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().nodeExists(path);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.getProperties().hasNext();
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().propertyExists(path);
    }

    public Property setProperty(String name, Value value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, Value[] values) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(values);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, String[] values) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(values);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, String value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, InputStream value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, boolean value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, double value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, long value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, Calendar value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, Node value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, Binary value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public Property setProperty(String name, BigDecimal value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
        return property;
    }

    public boolean isNode() {
        return true;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.itemData.getNodeType().isNodeType(nodeTypeName);
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.itemData.getNodeType();
    }

    public Item getPrimaryItem() throws RepositoryException {
        if (this.hasProperty("jcr:data")) {
            return this.getProperty("jcr:data");
        }
        if (this.hasNode("jcr:content")) {
            return this.getNode("jcr:content");
        }
        throw new ItemNotFoundException();
    }

    public int hashCode() {
        return this.itemData.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MockNode) {
            return this.itemData.equals(((MockNode)obj).itemData);
        }
        return false;
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return new NodeType[0];
    }

    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value[] values, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String[] values, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String value, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void addMixin(String pMixinName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean canAddMixin(String pMixinName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void cancelMerge(Version pVersion) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version checkin() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void checkout() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void doneMerge(Version pVersion) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version getBaseVersion() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getCorrespondingNodePath(String workspaceName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public int getIndex() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock getLock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public VersionHistory getVersionHistory() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean holdsLock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isCheckedOut() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isLocked() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeMixin(String mixinName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void unlock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void update(String srcWorkspaceName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void followLifecycleTransition(String transition) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeShare() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeSharedSet() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setPrimaryType(String pNodeTypeName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

