/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.sling.testing.mock.jcr.MockQueryManager;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class MockQuery
implements Query {
    private final MockQueryManager queryManager;
    private final String statement;
    private final String language;
    private long limit;
    private long offset;
    private Map<String, Value> variables = new HashMap<String, Value>();

    MockQuery(MockQueryManager queryManager, String statement, String language) {
        this.queryManager = queryManager;
        this.statement = statement;
        this.language = language;
    }

    public QueryResult execute() throws RepositoryException {
        return this.queryManager.executeQuery(this);
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getLimit() throws RepositoryException {
        return this.limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOffset() throws RepositoryException {
        return this.offset;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public void bindValue(String varName, Value value) throws RepositoryException {
        this.variables.put(varName, value);
    }

    public String[] getBindVariableNames() throws RepositoryException {
        Set<String> variableNames = this.variables.keySet();
        return variableNames.toArray(new String[variableNames.size()]);
    }

    public Map<String, Value> getBindVariables() throws RepositoryException {
        return ImmutableMap.copyOf(this.variables);
    }

    public String getStoredQueryPath() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Node storeAsNode(String absPath) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

