/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.Arrays;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.testing.mock.jcr.MockAuthorizable;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockUser
extends MockAuthorizable
implements User {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private char[] pwd = new char[0];
    private boolean disabled;
    private String disabledReason;

    public MockUser(@Nullable String id, @Nullable Principal principal, @NotNull Node homeNode, @NotNull MockUserManager mockUserMgr) {
        super(id, principal, homeNode, mockUserMgr);
    }

    public boolean isAdmin() {
        boolean result;
        block2: {
            result = false;
            try {
                result = "admin".equals(this.getID());
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Failed to determine if this is admin", (Throwable)e);
            }
        }
        return result;
    }

    public boolean isSystemUser() {
        return false;
    }

    @NotNull
    public Credentials getCredentials() throws RepositoryException {
        return new SimpleCredentials(this.id, this.pwd);
    }

    @NotNull
    public Impersonation getImpersonation() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void changePassword(@Nullable String password) throws RepositoryException {
        if (password == null) {
            throw new RepositoryException("Attempt to set 'null' password for user " + this.getID());
        }
        this.pwd = password.toCharArray();
    }

    public void changePassword(@Nullable String password, @NotNull String oldPassword) throws RepositoryException {
        if (!Arrays.equals(this.pwd, oldPassword.toCharArray())) {
            throw new RepositoryException("old password did not match");
        }
        this.changePassword(password);
    }

    public void disable(@Nullable String reason) throws RepositoryException {
        if (reason == null) {
            this.disabled = false;
            this.disabledReason = null;
        } else {
            this.disabled = true;
            this.disabledReason = reason;
        }
    }

    public boolean isDisabled() throws RepositoryException {
        return this.disabled;
    }

    @Nullable
    public String getDisabledReason() throws RepositoryException {
        return this.disabledReason;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MockUser [id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }
}

