/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class OsgiMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(OsgiMetadataUtil.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPathFactory XPATH_FACTORY;
    private static final BiMap<String, String> NAMESPACES;
    private static final NamespaceContext NAMESPACE_CONTEXT;

    private OsgiMetadataUtil() {
    }

    public static Document getMetadata(Class clazz) {
        String metadataPath = "/OSGI-INF/" + StringUtils.substringBefore((String)clazz.getName(), (String)"$") + ".xml";
        InputStream metadataStream = clazz.getResourceAsStream(metadataPath);
        if (metadataStream == null) {
            log.debug("No OSGi metadata found at {}", (Object)metadataPath);
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(metadataStream);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + metadataPath, ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + metadataPath, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + metadataPath, ex);
        }
        finally {
            try {
                metadataStream.close();
            }
            catch (IOException ex) {}
        }
    }

    public static Set<String> getServiceInterfaces(Class clazz, Document metadata) {
        String query;
        NodeList nodes;
        HashSet<String> serviceInterfaces = new HashSet<String>();
        if (metadata != null && (nodes = OsgiMetadataUtil.queryNodes(metadata, query = "/components/component[@name='" + clazz.getName() + "']/service/provide[@interface!='']")) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String serviceInterface = OsgiMetadataUtil.getAttributeValue(node, "interface");
                if (!StringUtils.isNotBlank((CharSequence)serviceInterface)) continue;
                serviceInterfaces.add(serviceInterface);
            }
        }
        return serviceInterfaces;
    }

    public static Map<String, Object> getProperties(Class clazz, Document metadata) {
        String query;
        NodeList nodes;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (metadata != null && (nodes = OsgiMetadataUtil.queryNodes(metadata, query = "/components/component[@name='" + clazz.getName() + "']/property[@name!='' and @value!='']")) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = OsgiMetadataUtil.getAttributeValue(node, "name");
                String value = OsgiMetadataUtil.getAttributeValue(node, "value");
                String type = OsgiMetadataUtil.getAttributeValue(node, "type");
                if (StringUtils.equals((CharSequence)"Integer", (CharSequence)type)) {
                    props.put(name, Integer.parseInt(value));
                    continue;
                }
                props.put(name, value);
            }
        }
        return props;
    }

    public static List<Reference> getReferences(Class clazz, Document metadata) {
        String query;
        NodeList nodes;
        ArrayList<Reference> references = new ArrayList<Reference>();
        if (metadata != null && (nodes = OsgiMetadataUtil.queryNodes(metadata, query = "/components/component[@name='" + clazz.getName() + "']/reference[@name!='']")) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                references.add(new Reference(node));
            }
        }
        return references;
    }

    public static String getActivateMethodName(Class clazz, Document metadata) {
        String query;
        Node node;
        if (metadata != null && (node = OsgiMetadataUtil.queryNode(metadata, query = "/components/component[@name='" + clazz.getName() + "']")) != null) {
            return OsgiMetadataUtil.getAttributeValue(node, "activate");
        }
        return null;
    }

    public static String getDeactivateMethodName(Class clazz, Document metadata) {
        String query;
        Node node;
        if (metadata != null && (node = OsgiMetadataUtil.queryNode(metadata, query = "/components/component[@name='" + clazz.getName() + "']")) != null) {
            return OsgiMetadataUtil.getAttributeValue(node, "deactivate");
        }
        return null;
    }

    private static NodeList queryNodes(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (NodeList)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static Node queryNode(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (Node)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static String getAttributeValue(Node node, String attributeName) {
        Node namedItem = node.getAttributes().getNamedItem(attributeName);
        if (namedItem != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        XPATH_FACTORY = XPathFactory.newInstance();
        NAMESPACES = HashBiMap.create();
        NAMESPACES.put((Object)"scr", (Object)"http://www.osgi.org/xmlns/scr/v1.1.0");
        NAMESPACE_CONTEXT = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)NAMESPACES.get((Object)prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)NAMESPACES.inverse().get((Object)namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return NAMESPACES.keySet().iterator();
            }
        };
    }

    public static class Reference {
        private final String name;
        private final String interfaceType;
        private final ReferenceCardinality cardinality;
        private final String bind;
        private final String unbind;

        public Reference(Node node) {
            this.name = OsgiMetadataUtil.getAttributeValue(node, "name");
            this.interfaceType = OsgiMetadataUtil.getAttributeValue(node, "interface");
            this.cardinality = this.toCardinality(OsgiMetadataUtil.getAttributeValue(node, "cardinality"));
            this.bind = OsgiMetadataUtil.getAttributeValue(node, "bind");
            this.unbind = OsgiMetadataUtil.getAttributeValue(node, "unbind");
        }

        private ReferenceCardinality toCardinality(String value) {
            for (ReferenceCardinality item : ReferenceCardinality.values()) {
                if (!StringUtils.equals((CharSequence)item.getCardinalityString(), (CharSequence)value)) continue;
                return item;
            }
            return ReferenceCardinality.MANDATORY_UNARY;
        }

        public String getName() {
            return this.name;
        }

        public String getInterfaceType() {
            return this.interfaceType;
        }

        public ReferenceCardinality getCardinality() {
            return this.cardinality;
        }

        public String getBind() {
            return this.bind;
        }

        public String getUnbind() {
            return this.unbind;
        }
    }
}

