/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

final class ReflectionServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectionServiceUtil.class);

    private ReflectionServiceUtil() {
    }

    public static boolean activateDeactivate(Object target, ComponentContext componentContext, boolean activate) {
        Class<?> targetClass = target.getClass();
        Document metadata = OsgiMetadataUtil.getMetadata(targetClass);
        String methodName = activate ? OsgiMetadataUtil.getActivateMethodName(targetClass, metadata) : OsgiMetadataUtil.getDeactivateMethodName(targetClass, metadata);
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return false;
        }
        Method method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{ComponentContext.class}, activate);
        if (method != null) {
            try {
                method.setAccessible(true);
                method.invoke(target, componentContext);
                return true;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Unable to invoke activate/deactivate method for class " + targetClass.getName(), ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Unable to invoke activate/deactivate method for class " + targetClass.getName(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Unable to invoke activate/deactivate method for class " + targetClass.getName(), ex.getCause());
            }
        }
        log.warn("Method {}(ComponentContext) not found in class {}", (Object)methodName, (Object)targetClass.getName());
        return false;
    }

    private static Method getMethod(Class clazz, String methodName, Class<?>[] signature, boolean activate) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || !Arrays.equals(method.getParameterTypes(), signature)) continue;
            return method;
        }
        return null;
    }

    public static boolean injectServices(Object target, BundleContext bundleContext) {
        Class<?> targetClass = target.getClass();
        List<OsgiMetadataUtil.Reference> references = ReflectionServiceUtil.getReferences(targetClass);
        boolean allInjected = true;
        for (OsgiMetadataUtil.Reference reference : references) {
            boolean injectSuccess = ReflectionServiceUtil.injectServiceReference(reference, target, bundleContext);
            allInjected = allInjected && injectSuccess;
        }
        return allInjected;
    }

    private static List<OsgiMetadataUtil.Reference> getReferences(Class clazz) {
        Document metadata = OsgiMetadataUtil.getMetadata(clazz);
        return OsgiMetadataUtil.getReferences(clazz, metadata);
    }

    private static boolean injectServiceReference(OsgiMetadataUtil.Reference reference, Object target, BundleContext bundleContext) {
        Class<?> type;
        Class<?> targetClass = target.getClass();
        try {
            type = Class.forName(reference.getInterfaceType());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to instantiate reference type: " + reference.getInterfaceType(), ex);
        }
        List<ServiceInfo> matchingServices = ReflectionServiceUtil.getMatchingServices(type, bundleContext);
        if (matchingServices.isEmpty()) {
            boolean isOptional;
            boolean bl = isOptional = reference.getCardinality() == ReferenceCardinality.OPTIONAL_UNARY || reference.getCardinality() == ReferenceCardinality.OPTIONAL_MULTIPLE;
            if (!isOptional) {
                log.warn("Unable to inject mandatory reference '{}' for class {}", (Object)reference.getName(), (Object)targetClass.getName());
            }
            return isOptional;
        }
        if (matchingServices.size() > 1 && (reference.getCardinality() == ReferenceCardinality.MANDATORY_UNARY || reference.getCardinality() == ReferenceCardinality.OPTIONAL_UNARY)) {
            log.warn("Multiple matches found for unary reference '{}' for class {}", (Object)reference.getName(), (Object)targetClass.getName());
            return false;
        }
        String bindMethodName = reference.getBind();
        if (StringUtils.isNotEmpty((CharSequence)bindMethodName)) {
            Method bindMethod = ReflectionServiceUtil.getFirstMethodWithNameAndSignature(targetClass, bindMethodName, new Class[]{type});
            if (bindMethod != null) {
                bindMethod.setAccessible(true);
                for (ServiceInfo matchingService : matchingServices) {
                    try {
                        bindMethod.invoke(target, matchingService.getServiceInstance());
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex.getCause());
                    }
                }
                return true;
            }
            Method bindMethodWithConfig = ReflectionServiceUtil.getFirstMethodWithNameAndSignature(targetClass, bindMethodName, new Class[]{type, Map.class});
            if (bindMethodWithConfig != null) {
                bindMethodWithConfig.setAccessible(true);
                for (ServiceInfo matchingService : matchingServices) {
                    try {
                        bindMethodWithConfig.invoke(target, matchingService.getServiceInstance(), matchingService.getServiceConfig());
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex.getCause());
                    }
                }
                return true;
            }
            Method bindMethodServiceReference = ReflectionServiceUtil.getFirstMethodWithNameAndSignature(targetClass, bindMethodName, new Class[]{ServiceReference.class});
            if (bindMethodServiceReference != null) {
                bindMethodServiceReference.setAccessible(true);
                for (ServiceInfo matchingService : matchingServices) {
                    if (matchingService.getServiceReference() == null) continue;
                    try {
                        bindMethodServiceReference.invoke(target, matchingService.getServiceReference());
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException("Unable to invoke method " + bindMethodName + " for class " + targetClass.getName(), ex.getCause());
                    }
                }
                return true;
            }
        }
        log.warn("Bind method not found for reference '{}' for class {}", (Object)reference.getName(), (Object)targetClass.getName());
        return false;
    }

    private static Method getFirstMethodWithNameAndSignature(Class<?> clazz, String methodName, Class<?>[] signature) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || !Arrays.equals(method.getParameterTypes(), signature)) continue;
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return ReflectionServiceUtil.getFirstMethodWithNameAndSignature(superClass, methodName, signature);
        }
        return null;
    }

    private static List<ServiceInfo> getMatchingServices(Class<?> type, BundleContext bundleContext) {
        ArrayList<ServiceInfo> matchingServices = new ArrayList<ServiceInfo>();
        try {
            ServiceReference[] references = bundleContext.getServiceReferences(type.getName(), null);
            if (references != null) {
                for (ServiceReference serviceReference : references) {
                    String[] keys;
                    Object serviceInstance = bundleContext.getService(serviceReference);
                    HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
                    for (String key : keys = serviceReference.getPropertyKeys()) {
                        serviceConfig.put(key, serviceReference.getProperty(key));
                    }
                    matchingServices.add(new ServiceInfo(serviceInstance, serviceConfig, serviceReference));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return matchingServices;
    }

    private static class ServiceInfo {
        private final Object serviceInstance;
        private final Map<String, Object> serviceConfig;
        private final ServiceReference serviceReference;

        public ServiceInfo(Object serviceInstance, Map<String, Object> serviceConfig, ServiceReference serviceReference) {
            this.serviceInstance = serviceInstance;
            this.serviceConfig = serviceConfig;
            this.serviceReference = serviceReference;
        }

        public Object getServiceInstance() {
            return this.serviceInstance;
        }

        public Map<String, Object> getServiceConfig() {
            return this.serviceConfig;
        }

        public ServiceReference getServiceReference() {
            return this.serviceReference;
        }
    }
}

