/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;

final class MapUtil {
    MapUtil() {
    }

    public static Dictionary<String, Object> toDictionary(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return new Hashtable<String, Object>(map);
    }

    public static Map<String, Object> toMap(Dictionary<String, Object> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public static Dictionary<String, Object> propertiesMergeWithOsgiMetadata(Object target, Dictionary<String, Object> properties) {
        Hashtable<String, Object> mergedProperties = new Hashtable<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(target.getClass());
        if (metadata != null && metadata.getProperties() != null) {
            for (Map.Entry<String, Object> entry : metadata.getProperties().entrySet()) {
                ((Dictionary)mergedProperties).put(entry.getKey(), entry.getValue());
            }
        }
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                ((Dictionary)mergedProperties).put(key, properties.get(key));
            }
        }
        return mergedProperties;
    }

    public static Map<String, Object> propertiesMergeWithOsgiMetadata(Object target, Map<String, Object> properties) {
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(target.getClass());
        if (metadata != null && metadata.getProperties() != null) {
            mergedProperties.putAll(metadata.getProperties());
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }
}

