/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.context;

import aQute.bnd.annotation.ConsumerType;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@ConsumerType
public class OsgiContextImpl {
    protected ComponentContext componentContext;

    protected void setUp() {
        this.registerDefaultServices();
    }

    protected void tearDown() {
    }

    private void registerDefaultServices() {
        this.registerInjectActivateService(new MockEventAdmin());
    }

    public final ComponentContext componentContext() {
        if (this.componentContext == null) {
            this.componentContext = MockOsgi.newComponentContext();
        }
        return this.componentContext;
    }

    public final BundleContext bundleContext() {
        return this.componentContext().getBundleContext();
    }

    public final <T> T registerService(T service) {
        return this.registerService(null, service, null);
    }

    public final <T> T registerService(Class<T> serviceClass, T service) {
        return this.registerService(serviceClass, service, null);
    }

    public final <T> T registerService(Class<T> serviceClass, T service, Map<String, Object> properties) {
        Hashtable<String, Object> serviceProperties = null;
        if (properties != null) {
            serviceProperties = new Hashtable<String, Object>(properties);
        }
        this.bundleContext().registerService(serviceClass != null ? serviceClass.getName() : null, service, serviceProperties);
        return service;
    }

    public final <T> T registerInjectActivateService(T service) {
        return this.registerInjectActivateService(service, null);
    }

    public final <T> T registerInjectActivateService(T service, Map<String, Object> properties) {
        MockOsgi.injectServices(service, this.bundleContext());
        MockOsgi.activate(service, this.bundleContext(), properties);
        this.registerService(null, service, properties);
        return service;
    }

    public final <ServiceType> ServiceType getService(Class<ServiceType> serviceType) {
        ServiceReference serviceReference = this.bundleContext().getServiceReference(serviceType.getName());
        if (serviceReference != null) {
            return (ServiceType)this.bundleContext().getService(serviceReference);
        }
        return null;
    }

    public final <ServiceType> ServiceType[] getServices(Class<ServiceType> serviceType, String filter) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext().getServiceReferences(serviceType.getName(), filter);
            if (serviceReferences != null) {
                Object[] services = (Object[])Array.newInstance(serviceType, serviceReferences.length);
                for (int i = 0; i < serviceReferences.length; ++i) {
                    services[i] = this.bundleContext().getService(serviceReferences[i]);
                }
                return services;
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException("Invalid filter syntax: " + filter, ex);
        }
    }
}

