/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class OsgiMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(OsgiMetadataUtil.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPathFactory XPATH_FACTORY;
    private static final BiMap<String, String> NAMESPACES;
    private static final OsgiMetadata NULL_METADATA;
    private static final LoadingCache<Class, OsgiMetadata> METADATA_CACHE;
    private static final NamespaceContext NAMESPACE_CONTEXT;

    private OsgiMetadataUtil() {
    }

    public static String getMetadataPath(Class clazz) {
        return "OSGI-INF/" + StringUtils.substringBefore((String)clazz.getName(), (String)"$") + ".xml";
    }

    public static String getOldMetadataMultiPath() {
        return "OSGI-INF/serviceComponents.xml";
    }

    public static OsgiMetadata getMetadata(Class clazz) {
        try {
            OsgiMetadata metadata = (OsgiMetadata)METADATA_CACHE.get((Object)clazz);
            if (metadata == NULL_METADATA) {
                return null;
            }
            return metadata;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error loading OSGi metadata from loader cache.", ex);
        }
    }

    private static List<Document> getMetadataDocument(Class clazz) {
        String metadataPath = OsgiMetadataUtil.getMetadataPath(clazz);
        InputStream metadataStream = OsgiMetadataUtil.class.getClassLoader().getResourceAsStream(metadataPath);
        if (metadataStream == null) {
            String oldMetadataPath = OsgiMetadataUtil.getOldMetadataMultiPath();
            log.debug("No OSGi metadata found at {}, try to fallback to {}", (Object)metadataPath, (Object)oldMetadataPath);
            try {
                Enumeration<URL> metadataUrls = OsgiMetadataUtil.class.getClassLoader().getResources(oldMetadataPath);
                ArrayList<Document> docs = new ArrayList<Document>();
                while (metadataUrls.hasMoreElements()) {
                    URL metadataUrl = metadataUrls.nextElement();
                    metadataStream = metadataUrl.openStream();
                    docs.add(OsgiMetadataUtil.toXmlDocument(metadataStream, oldMetadataPath));
                }
                if (docs.size() == 0) {
                    return null;
                }
                return docs;
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read classpath resource: " + oldMetadataPath, ex);
            }
        }
        return ImmutableList.of((Object)OsgiMetadataUtil.toXmlDocument(metadataStream, metadataPath));
    }

    private static Document toXmlDocument(InputStream inputStream, String path) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {}
        }
    }

    private static String getComponentXPathQuery(Class clazz) {
        String className = StringUtils.substringBefore((String)clazz.getName(), (String)"$$Enhancer");
        return "//*[implementation/@class='" + className + "' or @name='" + className + "']";
    }

    private static boolean matchesService(Class clazz, Document metadata) {
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz);
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        return nodes != null && nodes.getLength() > 0;
    }

    private static Set<String> getServiceInterfaces(Class clazz, Document metadata) {
        HashSet<String> serviceInterfaces = new HashSet<String>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/service/provide[@interface!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String serviceInterface = OsgiMetadataUtil.getAttributeValue(node, "interface");
                if (!StringUtils.isNotBlank((CharSequence)serviceInterface)) continue;
                serviceInterfaces.add(serviceInterface);
            }
        }
        return serviceInterfaces;
    }

    private static Map<String, Object> getProperties(Class clazz, Document metadata) {
        String[] value;
        String name;
        Node node;
        int i;
        HashMap<String, Object> props = new HashMap<String, Object>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/property[@name!='' and @value!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                name = OsgiMetadataUtil.getAttributeValue(node, "name");
                value = OsgiMetadataUtil.getAttributeValue(node, "value");
                String type = OsgiMetadataUtil.getAttributeValue(node, "type");
                if (StringUtils.equals((CharSequence)"Integer", (CharSequence)type)) {
                    props.put(name, Integer.parseInt((String)value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"Long", (CharSequence)type)) {
                    props.put(name, Long.parseLong((String)value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"Boolean", (CharSequence)type)) {
                    props.put(name, Boolean.parseBoolean((String)value));
                    continue;
                }
                props.put(name, value);
            }
        }
        if ((nodes = OsgiMetadataUtil.queryNodes(metadata, query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/property[@name!='' and text()!='']")) != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                name = OsgiMetadataUtil.getAttributeValue(node, "name");
                value = StringUtils.split((String)StringUtils.trim((String)node.getTextContent()), (String)"\n\r");
                for (int j = 0; j < value.length; ++j) {
                    value[j] = StringUtils.trim((String)value[j]);
                }
                props.put(name, value);
            }
        }
        return props;
    }

    private static List<Reference> getReferences(Class clazz, Document metadata) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/reference[@name!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                references.add(new Reference(clazz, node));
            }
        }
        return references;
    }

    private static String getLifecycleMethodName(Class clazz, Document metadata, String methodName) {
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz);
        Node node = OsgiMetadataUtil.queryNode(metadata, query);
        if (node != null) {
            return OsgiMetadataUtil.getAttributeValue(node, methodName);
        }
        return null;
    }

    private static NodeList queryNodes(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (NodeList)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static Node queryNode(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (Node)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static String getAttributeValue(Node node, String attributeName) {
        Node namedItem = node.getAttributes().getNamedItem(attributeName);
        if (namedItem != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        XPATH_FACTORY = XPathFactory.newInstance();
        NAMESPACES = HashBiMap.create();
        NAMESPACES.put((Object)"scr", (Object)"http://www.osgi.org/xmlns/scr/v1.1.0");
        NULL_METADATA = new OsgiMetadata();
        METADATA_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, OsgiMetadata>(){

            public OsgiMetadata load(Class clazz) throws Exception {
                List metadataDocuments = OsgiMetadataUtil.getMetadataDocument(clazz);
                if (metadataDocuments != null) {
                    for (Document metadataDocument : metadataDocuments) {
                        if (!OsgiMetadataUtil.matchesService(clazz, metadataDocument)) continue;
                        return new OsgiMetadata(clazz, metadataDocument);
                    }
                }
                return NULL_METADATA;
            }
        });
        NAMESPACE_CONTEXT = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)NAMESPACES.get((Object)prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)NAMESPACES.inverse().get((Object)namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return NAMESPACES.keySet().iterator();
            }
        };
    }

    static enum ReferencePolicy {
        STATIC,
        DYNAMIC;

    }

    static enum ReferenceCardinality {
        OPTIONAL_UNARY("0..1"),
        MANDATORY_UNARY("1..1"),
        OPTIONAL_MULTIPLE("0..n"),
        MANDATORY_MULTIPLE("1..n");

        private final String cardinalityString;

        private ReferenceCardinality(String cardinalityString) {
            this.cardinalityString = cardinalityString;
        }

        public String getCardinalityString() {
            return this.cardinalityString;
        }
    }

    static class Reference {
        private final Class<?> clazz;
        private final String name;
        private final String interfaceType;
        private final ReferenceCardinality cardinality;
        private final ReferencePolicy policy;
        private final String bind;
        private final String unbind;

        private Reference(Class<?> clazz, Node node) {
            this.clazz = clazz;
            this.name = OsgiMetadataUtil.getAttributeValue(node, "name");
            this.interfaceType = OsgiMetadataUtil.getAttributeValue(node, "interface");
            this.cardinality = Reference.toCardinality(OsgiMetadataUtil.getAttributeValue(node, "cardinality"));
            this.policy = Reference.toPolicy(OsgiMetadataUtil.getAttributeValue(node, "policy"));
            this.bind = OsgiMetadataUtil.getAttributeValue(node, "bind");
            this.unbind = OsgiMetadataUtil.getAttributeValue(node, "unbind");
        }

        public Class<?> getServiceClass() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public String getInterfaceType() {
            return this.interfaceType;
        }

        public ReferenceCardinality getCardinality() {
            return this.cardinality;
        }

        public ReferencePolicy getPolicy() {
            return this.policy;
        }

        public String getBind() {
            return this.bind;
        }

        public String getUnbind() {
            return this.unbind;
        }

        private static ReferenceCardinality toCardinality(String value) {
            for (ReferenceCardinality item : ReferenceCardinality.values()) {
                if (!StringUtils.equals((CharSequence)item.getCardinalityString(), (CharSequence)value)) continue;
                return item;
            }
            return ReferenceCardinality.MANDATORY_UNARY;
        }

        private static ReferencePolicy toPolicy(String value) {
            for (ReferencePolicy item : ReferencePolicy.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.name(), (CharSequence)value)) continue;
                return item;
            }
            return ReferencePolicy.STATIC;
        }
    }

    static class OsgiMetadata {
        private final Class<?> clazz;
        private final Set<String> serviceInterfaces;
        private final Map<String, Object> properties;
        private final List<Reference> references;
        private final String activateMethodName;
        private final String deactivateMethodName;
        private final String modifiedMethodName;

        private OsgiMetadata(Class<?> clazz, Document metadataDocument) {
            this.clazz = clazz;
            this.serviceInterfaces = OsgiMetadataUtil.getServiceInterfaces(clazz, metadataDocument);
            this.properties = OsgiMetadataUtil.getProperties(clazz, metadataDocument);
            this.references = OsgiMetadataUtil.getReferences(clazz, metadataDocument);
            this.activateMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "activate");
            this.deactivateMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "deactivate");
            this.modifiedMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "modified");
        }

        private OsgiMetadata() {
            this.clazz = null;
            this.serviceInterfaces = null;
            this.properties = null;
            this.references = null;
            this.activateMethodName = null;
            this.deactivateMethodName = null;
            this.modifiedMethodName = null;
        }

        public Class<?> getServiceClass() {
            return this.clazz;
        }

        public Set<String> getServiceInterfaces() {
            return this.serviceInterfaces;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        public String getActivateMethodName() {
            return this.activateMethodName;
        }

        public String getDeactivateMethodName() {
            return this.deactivateMethodName;
        }

        public String getModifiedMethodName() {
            return this.modifiedMethodName;
        }
    }
}

