/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class MapMergeUtil {
    private MapMergeUtil() {
    }

    public static Dictionary<String, Object> propertiesMergeWithOsgiMetadata(Object target, ConfigurationAdmin configAdmin, Dictionary<String, Object> properties) {
        return MapUtil.toDictionary(MapMergeUtil.propertiesMergeWithOsgiMetadata(target, configAdmin, MapUtil.toMap(properties)));
    }

    public static Map<String, Object> propertiesMergeWithOsgiMetadata(Object target, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        Map<String, Object> metadataProperties;
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(target.getClass());
        if (metadata != null && (metadataProperties = metadata.getProperties()) != null) {
            Object pid;
            mergedProperties.putAll(metadataProperties);
            if (configAdmin != null && (pid = metadataProperties.get("service.pid")) != null) {
                try {
                    Configuration config = configAdmin.getConfiguration(pid.toString());
                    mergedProperties.putAll(MapUtil.toMap(config.getProperties()));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to read config for pid " + pid, ex);
                }
            }
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }
}

