/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.ComponentContextBuilder;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.apache.sling.testing.mock.osgi.MockLogService;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public final class MockOsgi {
    private MockOsgi() {
    }

    public static BundleContext newBundleContext() {
        return new MockBundleContext();
    }

    public static void sendBundleEvent(BundleContext bundleContext, BundleEvent bundleEvent) {
        ((MockBundleContext)bundleContext).sendBundleEvent(bundleEvent);
    }

    public static ComponentContext newComponentContext() {
        return MockOsgi.componentContext().build();
    }

    public static ComponentContext newComponentContext(Dictionary<String, Object> properties) {
        return MockOsgi.componentContext().properties(properties).build();
    }

    public static ComponentContext newComponentContext(Map<String, Object> properties) {
        return MockOsgi.componentContext().properties(properties).build();
    }

    public static ComponentContext newComponentContext(BundleContext bundleContext, Dictionary<String, Object> properties) {
        return MockOsgi.componentContext().bundleContext(bundleContext).properties(properties).build();
    }

    public static ComponentContext newComponentContext(BundleContext bundleContext, Map<String, Object> properties) {
        return MockOsgi.componentContext().bundleContext(bundleContext).properties(properties).build();
    }

    public static ComponentContextBuilder componentContext() {
        return new ComponentContextBuilder();
    }

    public static LogService newLogService(Class<?> loggerContext) {
        return new MockLogService(loggerContext);
    }

    public static boolean injectServices(Object target, BundleContext bundleContext) {
        return OsgiServiceUtil.injectServices(target, bundleContext);
    }

    public static boolean activate(Object target, BundleContext bundleContext) {
        return MockOsgi.activate(target, bundleContext, (Dictionary<String, Object>)null);
    }

    public static boolean activate(Object target, BundleContext bundleContext, Dictionary<String, Object> properties) {
        Dictionary<String, Object> mergedProperties = MapUtil.propertiesMergeWithOsgiMetadata(target, MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.activateDeactivate(target, componentContext, true);
    }

    public static boolean activate(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        return MockOsgi.activate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean deactivate(Object target, BundleContext bundleContext) {
        return MockOsgi.deactivate(target, bundleContext, (Dictionary<String, Object>)null);
    }

    public static boolean deactivate(Object target, BundleContext bundleContext, Dictionary<String, Object> properties) {
        Dictionary<String, Object> mergedProperties = MapUtil.propertiesMergeWithOsgiMetadata(target, MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.activateDeactivate(target, componentContext, false);
    }

    public static boolean deactivate(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        return MockOsgi.deactivate(target, bundleContext, MapUtil.toDictionary(properties));
    }

    public static boolean modified(Object target, BundleContext bundleContext, Dictionary<String, Object> properties) {
        return MockOsgi.modified(target, bundleContext, MapUtil.toMap(properties));
    }

    public static boolean modified(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        Map<String, Object> mergedProperties = MapUtil.propertiesMergeWithOsgiMetadata(target, MockOsgi.getConfigAdmin(bundleContext), properties);
        ComponentContext componentContext = MockOsgi.newComponentContext(bundleContext, mergedProperties);
        return OsgiServiceUtil.modified(target, componentContext, mergedProperties);
    }

    public static void shutdown(BundleContext bundleContext) {
        ((MockBundleContext)bundleContext).shutdown();
    }

    private static ConfigurationAdmin getConfigAdmin(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref != null) {
            return (ConfigurationAdmin)bundleContext.getService(ref);
        }
        return null;
    }
}

