/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.FelixResolveContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;
import osgimock.org.apache.felix.framework.StatefulResolver;
import osgimock.org.apache.felix.framework.resolver.CandidateComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveContextImpl
extends ResolveContext
implements FelixResolveContext {
    private final StatefulResolver m_state;
    private final Map<Resource, Wiring> m_wirings;
    private final StatefulResolver.ResolverHookRecord m_resolverHookrecord;
    private final Collection<BundleRevision> m_mandatory;
    private final Collection<BundleRevision> m_optional;
    private final Collection<BundleRevision> m_ondemand;

    ResolveContextImpl(StatefulResolver state, Map<Resource, Wiring> wirings, StatefulResolver.ResolverHookRecord resolverHookRecord, Collection<BundleRevision> mandatory, Collection<BundleRevision> optional, Collection<BundleRevision> ondemand) {
        this.m_state = state;
        this.m_wirings = wirings;
        this.m_resolverHookrecord = resolverHookRecord;
        this.m_mandatory = mandatory;
        this.m_optional = optional;
        this.m_ondemand = ondemand;
    }

    public Collection<Resource> getMandatoryResources() {
        return new ArrayList<BundleRevision>(this.m_mandatory);
    }

    public Collection<Resource> getOptionalResources() {
        return new ArrayList<BundleRevision>(this.m_optional);
    }

    public Collection<Resource> getOndemandResources(Resource host) {
        return new ArrayList<BundleRevision>(this.m_ondemand);
    }

    public List<Capability> findProviders(Requirement br) {
        List<BundleCapability> result;
        if (!(br instanceof BundleRequirement)) {
            throw new IllegalStateException("Expected a BundleRequirement");
        }
        List<BundleCapability> caps = result = this.m_state.findProvidersInternal(this.m_resolverHookrecord, br, true, true);
        return caps;
    }

    public int insertHostedCapability(List<Capability> caps, HostedCapability hc) {
        int idx = Collections.binarySearch(caps, hc, new CandidateComparator());
        if (idx < 0) {
            idx = Math.abs(idx + 1);
        }
        caps.add(idx, (Capability)hc);
        return idx;
    }

    public boolean isEffective(Requirement br) {
        return this.m_state.isEffective(br);
    }

    public Map<Resource, Wiring> getWirings() {
        return this.m_wirings;
    }
}

