/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.resourceresolver.MockResource;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResourceResolver
implements ResourceResolver {
    private final Map<String, Map<String, Object>> resources;
    private final Map<String, Map<String, Object>> temporaryResources = new HashMap<String, Map<String, Object>>();
    private final Set<String> deletedResources = new HashSet<String>();
    private final EventAdmin eventAdmin;

    public MockResourceResolver(EventAdmin eventAdmin, Map<String, Map<String, Object>> resources) {
        this.eventAdmin = eventAdmin;
        this.resources = resources;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return null;
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        return this.getResource(absPath);
    }

    public Resource resolve(String absPath) {
        return this.getResource(absPath);
    }

    @Deprecated
    public Resource resolve(HttpServletRequest request) {
        return null;
    }

    public String map(String resourcePath) {
        return resourcePath;
    }

    public String map(HttpServletRequest request, String resourcePath) {
        return resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String path) {
        if (path.startsWith("/")) {
            if (this.deletedResources.contains(path)) {
                return null;
            }
            Map<String, Object> tempProps = this.temporaryResources.get(path);
            if (tempProps != null) {
                MockResource rsrc = new MockResource(path, tempProps, this);
                return rsrc;
            }
            Map<String, Map<String, Object>> rsrc = this.resources;
            synchronized (rsrc) {
                Map<String, Object> props = this.resources.get(path);
                if (props != null) {
                    MockResource rsrc2 = new MockResource(path, props, this);
                    return rsrc2;
                }
            }
        } else {
            for (String s : this.getSearchPath()) {
                Resource rsrc = this.getResource(s + '/' + path);
                if (rsrc == null) continue;
                return rsrc;
            }
        }
        return null;
    }

    public Resource getResource(Resource base, String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (path.startsWith("/")) {
            return this.getResource(path);
        }
        if (base.getPath().equals("/")) {
            return this.getResource(base.getPath() + path);
        }
        return this.getResource(base.getPath() + '/' + path);
    }

    public String[] getSearchPath() {
        return new String[]{"/libs", "/apps"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Resource> listChildren(Resource parent) {
        String prefixPath = parent.getPath() + "/";
        HashMap<String, Map<String, Object>> candidates = new HashMap<String, Map<String, Object>>();
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> entry : this.resources.entrySet()) {
                if (!entry.getKey().startsWith(prefixPath) || entry.getKey().lastIndexOf(47) >= prefixPath.length() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Map<String, Object>> entry : this.temporaryResources.entrySet()) {
                if (!entry.getKey().startsWith(prefixPath) || entry.getKey().lastIndexOf(47) >= prefixPath.length() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<MockResource> children = new ArrayList<MockResource>();
        for (Map.Entry<String, Map<String, Object>> entry : candidates.entrySet()) {
            children.add(new MockResource(entry.getKey(), entry.getValue(), this));
        }
        return children.iterator();
    }

    public Iterable<Resource> getChildren(final Resource parent) {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return MockResourceResolver.this.listChildren(parent);
            }
        };
    }

    public Iterator<Resource> findResources(String query, String language) {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        return null;
    }

    public boolean isLive() {
        return true;
    }

    public void close() {
    }

    public String getUserID() {
        return null;
    }

    public Iterator<String> getAttributeNames() {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public Object getAttribute(String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Resource resource) throws PersistenceException {
        this.deletedResources.add(resource.getPath());
        this.temporaryResources.remove(resource.getPath());
        String prefixPath = resource.getPath() + '/';
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> e : this.resources.entrySet()) {
                if (!e.getKey().startsWith(prefixPath)) continue;
                this.deletedResources.add(e.getKey());
            }
            Iterator<Map.Entry<String, Map<String, Object>>> i = this.temporaryResources.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Map<String, Object>> e;
                e = i.next();
                if (!e.getKey().startsWith(prefixPath)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource create(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        String path;
        String string = path = parent.getPath().equals("/") ? parent.getPath() + name : parent.getPath() + '/' + name;
        if (this.temporaryResources.containsKey(path)) {
            throw new PersistenceException("Path already exists: " + path);
        }
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            if (this.resources.containsKey(path)) {
                throw new PersistenceException("Path already exists: " + path);
            }
        }
        this.deletedResources.remove(path);
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        this.temporaryResources.put(path, properties);
        return new MockResource(path, properties, this);
    }

    public void revert() {
        this.deletedResources.clear();
        this.temporaryResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PersistenceException {
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (String path : this.deletedResources) {
                if (this.resources.remove(path) != null && this.eventAdmin != null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("path", path);
                    Event e = new Event("org/apache/sling/api/resource/Resource/REMOVED", props);
                    this.eventAdmin.sendEvent(e);
                }
                this.temporaryResources.remove(path);
            }
            for (String path : this.temporaryResources.keySet()) {
                boolean changed = this.resources.containsKey(path);
                this.resources.put(path, this.temporaryResources.get(path));
                if (this.eventAdmin == null) continue;
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("path", path);
                if (this.resources.get(path).get("sling:resourceType") != null) {
                    props.put("resourceType", this.resources.get(path).get("sling:resourceType"));
                }
                Event e = new Event(changed ? "org/apache/sling/api/resource/Resource/CHANGED" : "org/apache/sling/api/resource/Resource/ADDED", props);
                this.eventAdmin.sendEvent(e);
            }
        }
        this.revert();
    }

    public boolean hasChanges() {
        return this.temporaryResources.size() > 0 || this.deletedResources.size() > 0;
    }

    public String getParentResourceType(Resource resource) {
        return null;
    }

    public String getParentResourceType(String resourceType) {
        return null;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        return resource.getResourceType().equals(resourceType);
    }

    public void refresh() {
    }

    public void addChanged(String path, Map<String, Object> props) {
        this.temporaryResources.put(path, props);
    }
}

