/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;

public class MockResource
extends AbstractResource {
    private final String path;
    private final Map<String, Object> props;
    private final ResourceMetadata rm = new ResourceMetadata();
    private final ResourceResolver resolver;

    public MockResource(String path, Map<String, Object> props, ResourceResolver resolver) {
        this.path = path;
        this.props = props;
        this.resolver = resolver;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return (String)this.props.get("sling:resourceType");
    }

    public String getResourceSuperType() {
        return (String)this.props.get("sling:resourceSuperType");
    }

    public ResourceMetadata getResourceMetadata() {
        return this.rm;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)new ValueMapDecorator(this.props);
        }
        if (type == ModifiableValueMap.class) {
            ((MockResourceResolver)this.resolver).addChanged(this.path, this.props);
            return (AdapterType)new ModifiableValueMapDecorator(this.props);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return "MockResource [path=" + this.path + ", props=" + this.props + "]";
    }
}

