/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class MockValueMap
extends ValueMapDecorator {
    public MockValueMap() {
        this(new HashMap<String, Object>());
    }

    public MockValueMap(Map<String, Object> map) {
        super(MockValueMap.convertForWrite(map));
    }

    public <T> T get(String name, Class<T> type) {
        if (type == Date.class) {
            Calendar calendar = (Calendar)super.get(name, Calendar.class);
            if (calendar != null) {
                return (T)calendar.getTime();
            }
            return null;
        }
        if (type == InputStream.class) {
            byte[] data = (byte[])super.get(name, byte[].class);
            if (data != null) {
                return (T)new ByteArrayInputStream(data);
            }
            return null;
        }
        return (T)super.get(name, type);
    }

    public Object put(String key, Object value) {
        return super.put(key, MockValueMap.convertForWrite(value));
    }

    public void putAll(Map<? extends String, ?> map) {
        super.putAll((Map)MockValueMap.convertForWrite(map));
    }

    private static Object convertForWrite(Object value) {
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            value = calendar;
        } else if (value instanceof InputStream) {
            try {
                value = IOUtils.toByteArray((InputStream)((InputStream)value));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to convert input stream to byte array.");
            }
        }
        return value;
    }

    private static Map<String, Object> convertForWrite(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            newMap.put(entry.getKey(), MockValueMap.convertForWrite(entry.getValue()));
        }
        return newMap;
    }
}

