/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.resourceresolver.MockPropertyResource;
import org.apache.sling.testing.resourceresolver.MockResource;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactory;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactoryOptions;
import org.apache.sling.testing.resourceresolver.NamespaceMangler;
import org.osgi.service.event.Event;

public class MockResourceResolver
extends SlingAdaptable
implements ResourceResolver {
    private final Map<String, Map<String, Object>> resources;
    private final Map<String, Map<String, Object>> temporaryResources = new LinkedHashMap<String, Map<String, Object>>();
    private final Set<String> deletedResources = new HashSet<String>();
    private final MockResourceResolverFactoryOptions options;
    private final MockResourceResolverFactory factory;

    public MockResourceResolver(MockResourceResolverFactoryOptions options, MockResourceResolverFactory factory, Map<String, Map<String, Object>> resources) {
        this.factory = factory;
        this.options = options;
        this.resources = resources;
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        String path = absPath;
        String urlRemainder = null;
        int urlRemainderPos = Math.min(path.indexOf(63), path.indexOf(35));
        if (urlRemainderPos >= 0) {
            urlRemainder = path.substring(urlRemainderPos);
            path = path.substring(0, urlRemainderPos);
        }
        if (this.options.isMangleNamespacePrefixes()) {
            path = NamespaceMangler.unmangleNamespaces(path);
        }
        path = path + (urlRemainder != null ? urlRemainder : "");
        return this.getResource(path);
    }

    public Resource resolve(String absPath) {
        return this.resolve(null, absPath);
    }

    @Deprecated
    public Resource resolve(HttpServletRequest request) {
        return null;
    }

    public String map(String resourcePath) {
        return this.map(null, resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        String path = resourcePath;
        String urlRemainder = null;
        int urlRemainderPos = Math.min(path.indexOf(63), path.indexOf(35));
        if (urlRemainderPos >= 0) {
            urlRemainder = path.substring(urlRemainderPos);
            path = path.substring(0, urlRemainderPos);
        }
        if (this.options.isMangleNamespacePrefixes()) {
            path = NamespaceMangler.mangleNamespaces(path);
        }
        return path + (urlRemainder != null ? urlRemainder : "");
    }

    public Resource getResource(String path) {
        Resource resource = this.getResourceInternal(path);
        if (resource == null && path != null) {
            ValueMap props;
            String name = ResourceUtil.getName((String)path);
            String parentPath = ResourceUtil.getParent((String)path);
            Resource parentResource = this.getResourceInternal(parentPath);
            if (parentResource != null && (props = ResourceUtil.getValueMap((Resource)parentResource)).containsKey((Object)name)) {
                return new MockPropertyResource(path, props, this);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResourceInternal(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = ResourceUtil.normalize((String)path);
        if (normalizedPath.startsWith("/")) {
            if (this.deletedResources.contains(normalizedPath)) {
                return null;
            }
            Map<String, Object> tempProps = this.temporaryResources.get(normalizedPath);
            if (tempProps != null) {
                MockResource rsrc = new MockResource(normalizedPath, tempProps, this);
                return rsrc;
            }
            Map<String, Map<String, Object>> rsrc = this.resources;
            synchronized (rsrc) {
                Map<String, Object> props = this.resources.get(normalizedPath);
                if (props != null) {
                    MockResource rsrc2 = new MockResource(normalizedPath, props, this);
                    return rsrc2;
                }
            }
        } else {
            for (String s : this.getSearchPath()) {
                Resource rsrc = this.getResource(s + '/' + normalizedPath);
                if (rsrc == null) continue;
                return rsrc;
            }
        }
        return null;
    }

    public Resource getResource(Resource base, String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (path.startsWith("/")) {
            return this.getResource(path);
        }
        if (base.getPath().equals("/")) {
            return this.getResource(base.getPath() + path);
        }
        return this.getResource(base.getPath() + '/' + path);
    }

    public String[] getSearchPath() {
        return this.options.getSearchPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Resource> listChildren(Resource parent) {
        String prefixPath = parent.getPath() + "/";
        LinkedHashMap<String, Map<String, Object>> candidates = new LinkedHashMap<String, Map<String, Object>>();
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> entry : this.resources.entrySet()) {
                if (!entry.getKey().startsWith(prefixPath) || entry.getKey().lastIndexOf(47) >= prefixPath.length() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Map<String, Object>> entry : this.temporaryResources.entrySet()) {
                if (!entry.getKey().startsWith(prefixPath) || entry.getKey().lastIndexOf(47) >= prefixPath.length() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<MockResource> children = new ArrayList<MockResource>();
        for (Map.Entry<String, Map<String, Object>> entry : candidates.entrySet()) {
            children.add(new MockResource(entry.getKey(), entry.getValue(), this));
        }
        return children.iterator();
    }

    public Iterable<Resource> getChildren(final Resource parent) {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return MockResourceResolver.this.listChildren(parent);
            }
        };
    }

    public Iterator<Resource> findResources(String query, String language) {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        return null;
    }

    public boolean isLive() {
        return true;
    }

    public void close() {
        this.factory.closed(this);
    }

    public String getUserID() {
        return null;
    }

    public Iterator<String> getAttributeNames() {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public Object getAttribute(String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Resource resource) throws PersistenceException {
        this.deletedResources.add(resource.getPath());
        this.temporaryResources.remove(resource.getPath());
        String prefixPath = resource.getPath() + '/';
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> e : this.resources.entrySet()) {
                if (!e.getKey().startsWith(prefixPath)) continue;
                this.deletedResources.add(e.getKey());
            }
            Iterator<Map.Entry<String, Map<String, Object>>> i = this.temporaryResources.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Map<String, Object>> e;
                e = i.next();
                if (!e.getKey().startsWith(prefixPath)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource create(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        String path;
        String string = path = parent.getPath().equals("/") ? parent.getPath() + name : parent.getPath() + '/' + name;
        if (this.temporaryResources.containsKey(path)) {
            throw new PersistenceException("Path already exists: " + path);
        }
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            if (this.resources.containsKey(path) && !this.deletedResources.contains(path)) {
                throw new PersistenceException("Path already exists: " + path);
            }
        }
        this.deletedResources.remove(path);
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        MockResource mockResource = new MockResource(path, properties, this);
        this.temporaryResources.put(path, (Map<String, Object>)ResourceUtil.getValueMap((Resource)mockResource));
        return mockResource;
    }

    public void revert() {
        this.deletedResources.clear();
        this.temporaryResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PersistenceException {
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (String path : this.deletedResources) {
                if (this.resources.remove(path) != null && this.options.getEventAdmin() != null) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("path", path);
                    Event e = new Event("org/apache/sling/api/resource/Resource/REMOVED", props);
                    this.options.getEventAdmin().sendEvent(e);
                }
                this.temporaryResources.remove(path);
            }
            for (String path : this.temporaryResources.keySet()) {
                boolean changed = this.resources.containsKey(path);
                this.resources.put(path, this.temporaryResources.get(path));
                if (this.options.getEventAdmin() == null) continue;
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("path", path);
                if (this.resources.get(path).get("sling:resourceType") != null) {
                    ((Dictionary)props).put("resourceType", this.resources.get(path).get("sling:resourceType"));
                }
                Event e = new Event(changed ? "org/apache/sling/api/resource/Resource/CHANGED" : "org/apache/sling/api/resource/Resource/ADDED", props);
                this.options.getEventAdmin().sendEvent(e);
            }
        }
        this.revert();
    }

    public boolean hasChanges() {
        return this.temporaryResources.size() > 0 || this.deletedResources.size() > 0;
    }

    public String getParentResourceType(Resource resource) {
        return null;
    }

    public String getParentResourceType(String resourceType) {
        return null;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        return resource.getResourceType().equals(resourceType);
    }

    public void refresh() {
    }

    public void addChanged(String path, Map<String, Object> props) {
        this.temporaryResources.put(path, props);
    }

    public boolean hasChildren(Resource resource) {
        return this.listChildren(resource).hasNext();
    }
}

