/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NamespaceMangler {
    private static final String MANGLED_NAMESPACE_PREFIX = "_";
    private static final String MANGLED_NAMESPACE_SUFFIX = "_";
    private static final char NAMESPACE_SEPARATOR = ':';
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("/([^:/]+):");
    private static final Pattern MANGLED_NAMESPACE_PATTERN = Pattern.compile("/_([^_/]+)_");

    private NamespaceMangler() {
    }

    public static String mangleNamespaces(String path) {
        if (path == null) {
            return null;
        }
        Matcher matcher = NAMESPACE_PATTERN.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = "/_" + matcher.group(1) + "_";
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String unmangleNamespaces(String path) {
        if (path == null) {
            return null;
        }
        Matcher matcher = MANGLED_NAMESPACE_PATTERN.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = "/" + matcher.group(1) + ':';
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

