/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.instance;

import java.lang.reflect.Constructor;
import java.net.URI;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstance
implements Instance {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInstance.class);

    @Override
    public <T extends SlingClient> T getClient(Class<T> clientClass, String user, String pass) {
        SlingClient client;
        Constructor<T> constructor;
        InstanceConfiguration configuration = this.getConfiguration();
        try {
            constructor = clientClass.getConstructor(URI.class, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            client = (SlingClient)constructor.newInstance(configuration.getUrl(), user, pass);
        }
        catch (Exception e) {
            return null;
        }
        return (T)client;
    }

    @Override
    public <T extends SlingClient> T getAdminClient(Class<T> clientClass) {
        return this.getClient(clientClass, this.getConfiguration().getAdminUser(), this.getConfiguration().getAdminPassword());
    }

    @Override
    public SlingClient getAdminClient() {
        return this.getAdminClient(SlingClient.class);
    }
}

