/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.instance;

import java.util.List;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.junit.rules.instance.util.ConfigurationPool;
import org.junit.Assume;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExistingInstanceStatement
extends Statement {
    private final Logger logger = LoggerFactory.getLogger(ExistingInstanceStatement.class);
    private final ConfigurationPool configurationPool = new ConfigurationPool();
    private final Description description;
    private final Statement statement;
    private final String runMode;
    private Integer index;
    private InstanceConfiguration configuration;
    private final InstanceConfiguration defaultConfiguration;

    public ExistingInstanceStatement(Description description, Statement statement, String runMode, InstanceConfiguration defaultConfiguration) {
        this.description = description;
        this.statement = statement;
        this.runMode = runMode;
        this.defaultConfiguration = defaultConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        this.takeMatchingQuickstart();
        this.assumeMatchingQuickstartIsFound();
        try {
            this.statement.evaluate();
        }
        finally {
            this.returnQuickstart();
        }
    }

    private void assumeMatchingQuickstartIsFound() {
        if (this.index == null) {
            Assume.assumeNotNull((Object[])new Object[]{this.defaultConfiguration});
            this.configuration = this.defaultConfiguration;
            this.logger.info("Using default InstanceConfiguration provided (URL: {}, runmode: {}) for test {}", new Object[]{this.configuration.getUrl(), this.configuration.getRunmode(), this.description});
        }
    }

    private void takeMatchingQuickstart() {
        List<InstanceConfiguration> configurations = this.configurationPool.getConfigurations();
        for (int i = 0; i < configurations.size(); ++i) {
            InstanceConfiguration configuration = configurations.get(i);
            if (!this.runMode.equals(configuration.getRunmode()) || this.configurationPool.isTaken(i)) continue;
            this.logger.info("InstanceConfiguration (URL: {}, runmode: {}) found for test {}", new Object[]{configuration.getUrl(), this.runMode, this.description});
            this.takeQuickstart(i);
            return;
        }
    }

    private void takeQuickstart(Integer index) {
        this.configuration = this.configurationPool.takeConfiguration(this.description, index);
        this.index = index;
    }

    private void returnQuickstart() {
        if (this.index == null) {
            return;
        }
        this.configurationPool.returnConfiguration(this.description, this.index);
        this.index = null;
    }

    public InstanceConfiguration getConfiguration() {
        return this.configuration;
    }
}

