/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.state.ConflictType;

public final class StringCache {
    private static final Map<String, String> CONSTANTS = StringCache.createStringMap("jcr:autoCreated", "jcr:baseVersion", "jcr:child", "jcr:childNodeDefinition", "jcr:content", "jcr:created", "jcr:data", "jcr:defaultPrimaryType", "jcr:defaultValues", "jcr:encoding", "jcr:frozenMixinTypes", "jcr:frozenNode", "jcr:frozenPrimaryType", "jcr:frozenUuid", "jcr:hasOrderableChildNodes", "jcr:isCheckedOut", "jcr:isMixin", "jcr:language", "jcr:lastModified", "jcr:lockIsDeep", "jcr:lockOwner", "jcr:mandatory", "jcr:mergeFailed", "jcr:mimeType", "jcr:mixinTypes", "jcr:multiple", "jcr:name", "jcr:nodeTypeName", "jcr:onParentVersion", "jcr:predecessors", "jcr:primaryItemName", "jcr:primaryType", "jcr:propertyDefinition", "jcr:protected", "jcr:requiredPrimaryTypes", "jcr:requiredType", "jcr:rootVersion", "jcr:sameNameSiblings", "jcr:statement", "jcr:successors", "jcr:supertypes", "jcr:system", "jcr:uuid", "jcr:valueConstraints", "jcr:versionHistory", "jcr:versionLabels", "jcr:versionStorage", "jcr:versionableUuid", "jcr:path", "jcr:score", "mix:lockable", "mix:referenceable", "mix:versionable", "mix:shareable", "nt:base", "nt:childNodeDefinition", "nt:file", "nt:folder", "nt:frozenNode", "nt:hierarchyNode", "nt:linkedFile", "nt:nodeType", "nt:propertyDefinition", "nt:query", "nt:resource", "nt:unstructured", "nt:version", "nt:versionHistory", "nt:versionLabels", "nt:versionedChild", "jcr:nodeTypes", "jcr:isAbstract", "jcr:isQueryable", "jcr:isFullTextSearchable", "jcr:isQueryOrderable", "jcr:availableQueryOperators", "rep:root", "rep:system", "jcr:createdBy", "jcr:lastModifiedBy", "mix:created", "mix:lastModified", "rep:MergeConflict", "rep:ours", ConflictType.DELETE_CHANGED_PROPERTY.getName(), ConflictType.DELETE_CHANGED_NODE.getName(), ConflictType.ADD_EXISTING_PROPERTY.getName(), ConflictType.CHANGE_DELETED_PROPERTY.getName(), ConflictType.CHANGE_CHANGED_PROPERTY.getName(), ConflictType.DELETE_DELETED_PROPERTY.getName(), ConflictType.ADD_EXISTING_NODE.getName(), ConflictType.CHANGE_DELETED_NODE.getName(), ConflictType.DELETE_DELETED_NODE.getName(), "jcr:activity", "jcr:activities", "jcr:activityTitle", "nt:activity", "rep:Activities", "jcr:configuration", "jcr:configurations", "jcr:root", "nt:configuration", "rep:Configurations");
    private static final int STRING_CACHE_SIZE = 1024;
    private static final String[] STRING_CACHE = new String[1024];

    private StringCache() {
    }

    private static Map<String, String> createStringMap(String ... strings) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : strings) {
            builder.put((Object)string, (Object)string);
        }
        return builder.build();
    }

    public static String get(String s) {
        String constant = CONSTANTS.get(s);
        if (constant != null) {
            return constant;
        }
        int index = s.hashCode() & 0x3FF;
        String cached = STRING_CACHE[index];
        if (!s.equals(cached)) {
            StringCache.STRING_CACHE[index] = cached = new String(s);
        }
        return cached;
    }
}

