/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Value;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.util.GenericDescriptors;

public class ContentRepositoryImpl
implements ContentRepository,
Closeable {
    private final NodeStore nodeStore;
    private final CommitHook commitHook;
    private final String defaultWorkspaceName;
    private final SecurityProvider securityProvider;
    private final QueryIndexProvider indexProvider;
    private final QueryEngineSettings queryEngineSettings;
    private GenericDescriptors descriptors;

    public ContentRepositoryImpl(@Nonnull NodeStore nodeStore, @Nonnull CommitHook commitHook, @Nonnull String defaultWorkspaceName, QueryEngineSettings queryEngineSettings, @Nullable QueryIndexProvider indexProvider, @Nonnull SecurityProvider securityProvider) {
        this.nodeStore = (NodeStore)Preconditions.checkNotNull((Object)nodeStore);
        this.commitHook = (CommitHook)Preconditions.checkNotNull((Object)commitHook);
        this.defaultWorkspaceName = (String)Preconditions.checkNotNull((Object)defaultWorkspaceName);
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        this.queryEngineSettings = queryEngineSettings != null ? queryEngineSettings : new QueryEngineSettings();
        this.indexProvider = indexProvider != null ? indexProvider : new CompositeQueryIndexProvider(new QueryIndexProvider[0]);
    }

    @Override
    @Nonnull
    public ContentSession login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException {
        if (workspaceName == null) {
            workspaceName = this.defaultWorkspaceName;
        }
        if (!this.defaultWorkspaceName.equals(workspaceName)) {
            throw new NoSuchWorkspaceException(workspaceName);
        }
        LoginContextProvider lcProvider = this.securityProvider.getConfiguration(AuthenticationConfiguration.class).getLoginContextProvider(this);
        LoginContext loginContext = lcProvider.getLoginContext(credentials, workspaceName);
        loginContext.login();
        return new ContentSessionImpl(loginContext, this.securityProvider, workspaceName, this.nodeStore, this.commitHook, this.queryEngineSettings, this.indexProvider);
    }

    @Override
    @Nonnull
    public Descriptors getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.createDescriptors();
        }
        return this.descriptors;
    }

    @Override
    public void close() throws IOException {
    }

    @Nonnull
    protected GenericDescriptors createDescriptors() {
        SimpleValueFactory valueFactory = new SimpleValueFactory();
        Value trueValue = valueFactory.createValue(true);
        Value falseValue = valueFactory.createValue(false);
        GenericDescriptors gd = new GenericDescriptors().put("identifier.stability", valueFactory.createValue("identifier.stability.method.duration"), true, true).put("level.1.supported", trueValue, true, true).put("level.2.supported", trueValue, true, true).put("option.node.type.management.supported", trueValue, true, true).put("node.type.management.autocreated.definitions.supported", trueValue, true, true).put("node.type.management.inheritance", valueFactory.createValue("node.type.management.inheritance.single"), true, true).put("node.type.management.multiple.binary.properties.supported", trueValue, true, true).put("node.type.management.multivalued.properties.supported", trueValue, true, true).put("node.type.management.orderable.child.nodes.supported", trueValue, true, true).put("node.type.management.overrides.supported", trueValue, true, true).put("node.type.management.primary.item.name.supported", trueValue, true, true).put("node.type.management.property.types", new Value[]{valueFactory.createValue("String"), valueFactory.createValue("Binary"), valueFactory.createValue("Long"), valueFactory.createValue("Long"), valueFactory.createValue("Double"), valueFactory.createValue("Decimal"), valueFactory.createValue("Date"), valueFactory.createValue("Boolean"), valueFactory.createValue("Name"), valueFactory.createValue("Path"), valueFactory.createValue("Reference"), valueFactory.createValue("WeakReference"), valueFactory.createValue("URI"), valueFactory.createValue("undefined")}, false, true).put("node.type.management.residual.definitions.supported", trueValue, true, true).put("node.type.management.same.name.siblings.supported", falseValue, true, true).put("node.type.management.value.constraints.supported", trueValue, true, true).put("node.type.management.update.in.use.suported", falseValue, true, true).put("option.access.control.supported", trueValue, true, true).put("option.journaled.observation.supported", falseValue, true, true).put("option.lifecycle.supported", falseValue, true, true).put("option.locking.supported", falseValue, true, true).put("option.observation.supported", trueValue, true, true).put("option.node.and.property.with.same.name.supported", trueValue, true, true).put("option.query.sql.supported", falseValue, true, true).put("option.retention.supported", falseValue, true, true).put("option.shareable.nodes.supported", falseValue, true, true).put("option.simple.versioning.supported", falseValue, true, true).put("option.transactions.supported", falseValue, true, true).put("option.unfiled.content.supported", falseValue, true, true).put("option.update.mixin.node.types.supported", trueValue, true, true).put("option.update.primary.node.type.supported", trueValue, true, true).put("option.versioning.supported", trueValue, true, true).put("option.workspace.management.supported", falseValue, true, true).put("option.xml.export.supported", falseValue, true, true).put("option.xml.import.supported", falseValue, true, true).put("option.activities.supported", falseValue, true, true).put("option.baselines.supported", falseValue, true, true).put("query.full.text.search.supported", falseValue, true, true).put("query.joins", valueFactory.createValue("query.joins.none"), true, true).put("query.languages", new Value[0], false, true).put("query.stored.queries.supported", falseValue, true, true).put("query.xpath.doc.order", falseValue, true, true).put("query.xpath.pos.index", falseValue, true, true).put("jcr.repository.name", valueFactory.createValue("Apache Jackrabbit Oak"), true, true).put("jcr.repository.version", valueFactory.createValue(ContentRepositoryImpl.getVersion()), true, true).put("jcr.repository.vendor", valueFactory.createValue("The Apache Software Foundation"), true, true).put("jcr.repository.vendor.url", valueFactory.createValue("http://www.apache.org/"), true, true).put("jcr.specification.name", valueFactory.createValue("Content Repository for Java Technology API"), true, true).put("jcr.specification.version", valueFactory.createValue("2.0"), true, true).put("write.supported", trueValue, true, true);
        gd.put("option.user.management.supported", falseValue, true, false);
        gd.put("option.principal.management.supported", falseValue, true, false);
        gd.put("option.privilege.management.supported", falseValue, true, false);
        for (SecurityConfiguration securityConfiguration : this.securityProvider.getConfigurations()) {
            String name = securityConfiguration.getName();
            if ("org.apache.jackrabbit.oak.user".equals(name)) {
                gd.put("option.user.management.supported", trueValue, true, false);
                continue;
            }
            if ("org.apache.jackrabbit.oak.principal".equals(name)) {
                gd.put("option.principal.management.supported", trueValue, true, false);
                continue;
            }
            if (!"org.apache.jackrabbit.oak.privilege".equals(name)) continue;
            gd.put("option.privilege.management.supported", trueValue, true, false);
        }
        return gd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static String getVersion() {
        InputStream stream = ContentRepositoryImpl.class.getResourceAsStream("/META-INF/maven/org.apache.jackrabbit/oak-core/pom.properties");
        if (stream != null) {
            String string;
            try {
                Properties properties = new Properties();
                properties.load(stream);
                string = properties.getProperty("version");
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            stream.close();
            return string;
        }
        return "SNAPSHOT";
    }
}

