/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.jcr.repository.RepositoryImpl;
import org.apache.jackrabbit.oak.plugins.atomic.AtomicCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceIndexProvider;
import org.apache.jackrabbit.oak.plugins.itemsave.ItemSaveValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NameValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.version.VersionEditorProvider;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class Jcr {
    public static final int DEFAULT_OBSERVATION_QUEUE_LENGTH = 1000;
    private final Oak oak;
    private final CompositeConflictHandler conflictHandler = JcrConflictHandler.createJcrConflictHandler();
    private SecurityProvider securityProvider;
    private int observationQueueLength = 1000;
    private CommitRateLimiter commitRateLimiter = null;

    public Jcr(Oak oak) {
        this.oak = oak;
        this.with(new InitialContent());
        oak.with(this.conflictHandler);
        this.with(new EditorHook(new VersionEditorProvider()));
        this.with(new SecurityProviderImpl());
        this.with(new ItemSaveValidatorProvider());
        this.with(new NameValidatorProvider());
        this.with(new NamespaceEditorProvider());
        this.with(new TypeEditorProvider());
        this.with(new ConflictValidatorProvider());
        this.with(new AtomicCounterEditorProvider());
        this.with(new ReferenceEditorProvider());
        this.with(new ReferenceIndexProvider());
        this.with(new PropertyIndexEditorProvider());
        this.with(new NodeCounterEditorProvider());
        this.with(new PropertyIndexProvider());
        this.with(new OrderedPropertyIndexProvider());
        this.with(new NodeTypeIndexProvider());
        this.with(new OrderedPropertyIndexEditorProvider());
    }

    public Jcr() {
        this(new Oak());
    }

    public Jcr(NodeStore store) {
        this(new Oak(store));
    }

    @Nonnull
    public final Jcr with(@Nonnull RepositoryInitializer initializer) {
        this.oak.with((RepositoryInitializer)Preconditions.checkNotNull((Object)initializer));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull QueryIndexProvider provider) {
        this.oak.with((QueryIndexProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull IndexEditorProvider indexEditorProvider) {
        this.oak.with((IndexEditorProvider)Preconditions.checkNotNull((Object)indexEditorProvider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull CommitHook hook) {
        this.oak.with((CommitHook)Preconditions.checkNotNull((Object)hook));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull EditorProvider provider) {
        this.oak.with((EditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Editor editor) {
        this.oak.with((Editor)Preconditions.checkNotNull((Object)editor));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull SecurityProvider securityProvider) {
        this.oak.with((SecurityProvider)Preconditions.checkNotNull((Object)securityProvider));
        this.securityProvider = securityProvider;
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull PartialConflictHandler conflictHandler) {
        this.conflictHandler.addHandler((PartialConflictHandler)Preconditions.checkNotNull((Object)conflictHandler));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull ScheduledExecutorService executor) {
        this.oak.with((ScheduledExecutorService)Preconditions.checkNotNull((Object)executor));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Executor executor) {
        this.oak.with((Executor)Preconditions.checkNotNull((Object)executor));
        return this;
    }

    @Nonnull
    public final Jcr with(@Nonnull Observer observer) {
        this.oak.with((Observer)Preconditions.checkNotNull((Object)observer));
        return this;
    }

    @Nonnull
    public Jcr withAsyncIndexing() {
        this.oak.withAsyncIndexing();
        return this;
    }

    @Nonnull
    public Jcr withObservationQueueLength(int observationQueueLength) {
        this.observationQueueLength = observationQueueLength;
        return this;
    }

    @Nonnull
    public Jcr with(CommitRateLimiter commitRateLimiter) {
        this.oak.with(commitRateLimiter);
        this.commitRateLimiter = commitRateLimiter;
        return this;
    }

    @Nonnull
    public Jcr with(QueryEngineSettings qs) {
        this.oak.with(qs);
        return this;
    }

    public Repository createRepository() {
        return new RepositoryImpl(this.oak.createContentRepository(), this.oak.getWhiteboard(), this.securityProvider, this.observationQueueLength, this.commitRateLimiter);
    }
}

