/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.osgi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ObserverTracker
implements ServiceTrackerCustomizer {
    private final Map<ServiceReference, Closeable> subscriptions = Maps.newHashMap();
    private final Observable observable;
    private BundleContext bundleContext;
    private ServiceTracker observerTracker;

    public ObserverTracker(@Nonnull Observable observable) {
        this.observable = (Observable)Preconditions.checkNotNull((Object)observable);
    }

    public void start(@Nonnull BundleContext bundleContext) {
        Preconditions.checkState((this.bundleContext == null ? 1 : 0) != 0);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.observerTracker = new ServiceTracker(bundleContext, Observer.class.getName(), (ServiceTrackerCustomizer)this);
        this.observerTracker.open();
    }

    public void stop() {
        Preconditions.checkState((this.bundleContext != null ? 1 : 0) != 0);
        this.observerTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        if (service instanceof Observer) {
            this.subscriptions.put(reference, this.observable.addObserver((Observer)service));
            return service;
        }
        this.bundleContext.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.subscriptions.containsKey(reference)) {
            Closeables.closeQuietly((Closeable)this.subscriptions.get(reference));
            this.bundleContext.ungetService(reference);
        }
    }
}

