/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;

class Branch {
    private final ConcurrentSkipListMap<Revision, BranchCommit> commits;
    private final Revision base;
    private final BranchReference ref;

    Branch(@Nonnull SortedSet<Revision> commits, @Nonnull Revision base, @Nonnull ReferenceQueue<Object> queue, @Nullable Object guard) {
        Preconditions.checkArgument((!((Revision)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"base is not a trunk revision: %s", (Object[])new Object[]{base});
        this.base = base;
        this.commits = new ConcurrentSkipListMap(commits.comparator());
        for (Revision r : commits) {
            this.commits.put(r.asBranchRevision(), new BranchCommitImpl(base, r.asBranchRevision()));
        }
        this.ref = guard != null ? new BranchReference(queue, this, guard) : null;
    }

    @Nonnull
    Revision getBase() {
        return this.base;
    }

    @Nonnull
    Revision getBase(@Nonnull Revision r) {
        BranchCommit c = this.commits.get(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
        if (c == null) {
            throw new IllegalArgumentException("Revision " + r + " is not a commit in this branch");
        }
        return c.getBase();
    }

    void rebase(@Nonnull Revision head, @Nonnull Revision base) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)head)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{head});
        Preconditions.checkArgument((!((Revision)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"Not a trunk revision: %s", (Object[])new Object[]{base});
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument((this.commits.comparator().compare(head, last) > 0 ? 1 : 0) != 0);
        this.commits.put(head, new RebaseCommit(base, head, this.commits));
    }

    void addCommit(@Nonnull Revision r) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)r)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{r});
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument((this.commits.comparator().compare(r, last) > 0 ? 1 : 0) != 0);
        this.commits.put(r, new BranchCommitImpl(this.commits.get(last).getBase(), r));
    }

    SortedSet<Revision> getCommits() {
        return this.commits.keySet();
    }

    boolean hasCommits() {
        return !this.commits.isEmpty();
    }

    boolean containsCommit(@Nonnull Revision r) {
        return this.commits.containsKey(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
    }

    @CheckForNull
    BranchCommit getCommit(@Nonnull Revision r) {
        return this.commits.get(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
    }

    @CheckForNull
    BranchReference getRef() {
        return this.ref;
    }

    public void removeCommit(@Nonnull Revision r) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)r)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{r});
        this.commits.remove(r);
    }

    public void applyTo(@Nonnull UnsavedModifications trunk, @Nonnull Revision mergeCommit) {
        Preconditions.checkNotNull((Object)trunk);
        for (BranchCommit c : this.commits.values()) {
            c.applyTo(trunk, mergeCommit);
        }
    }

    @CheckForNull
    public Revision getUnsavedLastRevision(String path, Revision readRevision) {
        readRevision = readRevision.asBranchRevision();
        for (Revision r : this.commits.descendingKeySet()) {
            BranchCommit c;
            if (readRevision.compareRevisionTime(r) < 0 || !(c = this.commits.get(r)).isModified(path)) continue;
            return r;
        }
        return null;
    }

    public boolean isHead(@Nonnull Revision rev) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)rev)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{rev});
        return ((Revision)Preconditions.checkNotNull((Object)rev)).equals(this.commits.lastKey());
    }

    static final class BranchReference
    extends WeakReference<Object> {
        private final Branch branch;

        private BranchReference(@Nonnull ReferenceQueue<Object> queue, @Nonnull Branch branch, @Nonnull Object referent) {
            super(Preconditions.checkNotNull((Object)referent), queue);
            this.branch = (Branch)Preconditions.checkNotNull((Object)branch);
        }

        Branch getBranch() {
            return this.branch;
        }
    }

    private static class RebaseCommit
    extends BranchCommit {
        private final NavigableMap<Revision, BranchCommit> previous;

        RebaseCommit(Revision base, Revision commit, NavigableMap<Revision, BranchCommit> previous) {
            super(base, commit);
            this.previous = RebaseCommit.squash(previous);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (BranchCommit c : this.previous.values()) {
                c.applyTo(trunk, commit);
            }
        }

        @Override
        boolean isModified(String path) {
            for (BranchCommit c : this.previous.values()) {
                if (!c.isModified(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isRebase() {
            return true;
        }

        @Override
        Iterable<String> getModifiedPaths() {
            Iterable paths = Iterables.transform(this.previous.values(), (Function)new Function<BranchCommit, Iterable<String>>(){

                public Iterable<String> apply(BranchCommit branchCommit) {
                    return branchCommit.getModifiedPaths();
                }
            });
            return Iterables.concat((Iterable)paths);
        }

        private static NavigableMap<Revision, BranchCommit> squash(NavigableMap<Revision, BranchCommit> previous) {
            TreeMap<Revision, BranchCommit> result = new TreeMap<Revision, BranchCommit>(previous.comparator());
            for (Map.Entry e : previous.entrySet()) {
                if (((BranchCommit)e.getValue()).isRebase()) continue;
                result.put((Revision)e.getKey(), (BranchCommit)e.getValue());
            }
            return result;
        }

        @Override
        public void track(String path) {
            throw new UnsupportedOperationException("RebaseCommit is read-only");
        }

        public String toString() {
            return "R (" + this.previous.size() + ")";
        }
    }

    private static class BranchCommitImpl
    extends BranchCommit {
        private final Set<String> modifications = Sets.newHashSet();

        BranchCommitImpl(Revision base, Revision commit) {
            super(base, commit);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (String p : this.modifications) {
                trunk.put(p, commit);
            }
        }

        @Override
        boolean isModified(String path) {
            return this.modifications.contains(path);
        }

        @Override
        Iterable<String> getModifiedPaths() {
            return this.modifications;
        }

        @Override
        protected boolean isRebase() {
            return false;
        }

        @Override
        public void track(String path) {
            this.modifications.add(path);
        }

        public String toString() {
            return "B (" + this.modifications.size() + ")";
        }
    }

    static abstract class BranchCommit
    implements LastRevTracker {
        protected final Revision base;
        protected final Revision commit;

        BranchCommit(Revision base, Revision commit) {
            this.base = base;
            this.commit = commit;
        }

        Revision getBase() {
            return this.base;
        }

        abstract void applyTo(UnsavedModifications var1, Revision var2);

        abstract boolean isModified(String var1);

        abstract Iterable<String> getModifiedPaths();

        protected abstract boolean isRebase();
    }
}

