/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Checkpoints {
    private static final String ID = "checkpoint";
    private static final String PROP_CHECKPOINT = "data";
    static final int CLEANUP_INTERVAL = 100;
    private final DocumentNodeStore nodeStore;
    private final DocumentStore store;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger createCounter = new AtomicInteger();
    private final Object cleanupLock = new Object();

    Checkpoints(DocumentNodeStore store) {
        this.nodeStore = store;
        this.store = store.getDocumentStore();
        this.createIfNotExist();
    }

    public Revision create(long lifetimeInMillis, Map<String, String> info) {
        Revision r = this.nodeStore.getHeadRevision();
        this.createCounter.getAndIncrement();
        this.performCleanupIfRequired();
        UpdateOp op = new UpdateOp(ID, false);
        long endTime = BigInteger.valueOf(this.nodeStore.getClock().getTime()).add(BigInteger.valueOf(lifetimeInMillis)).min(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
        op.setMapEntry(PROP_CHECKPOINT, r, new Info(endTime, info).toString());
        this.store.createOrUpdate(Collection.SETTINGS, op);
        return r;
    }

    public void release(String checkpoint) {
        UpdateOp op = new UpdateOp(ID, false);
        op.removeMapEntry(PROP_CHECKPOINT, Revision.fromString(checkpoint));
        this.store.findAndUpdate(Collection.SETTINGS, op);
    }

    @CheckForNull
    public Revision getOldestRevisionToKeep() {
        SortedMap<Revision, Info> checkpoints = this.getCheckpoints();
        if (checkpoints == null) {
            this.log.debug("No checkpoint registered so far");
            return null;
        }
        long currentTime = this.nodeStore.getClock().getTime();
        UpdateOp op = new UpdateOp(ID, false);
        Revision lastAliveRevision = null;
        long oldestExpiryTime = 0L;
        for (Map.Entry<Revision, Info> e : checkpoints.entrySet()) {
            long expiryTime = e.getValue().getExpiryTime();
            if (currentTime > expiryTime) {
                op.removeMapEntry(PROP_CHECKPOINT, e.getKey());
                continue;
            }
            if (expiryTime <= oldestExpiryTime) continue;
            oldestExpiryTime = expiryTime;
            lastAliveRevision = e.getKey();
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.SETTINGS, op);
            this.log.debug("Purged {} expired checkpoints", (Object)op.getChanges().size());
        }
        return lastAliveRevision;
    }

    @CheckForNull
    SortedMap<Revision, Info> getCheckpoints() {
        Document cdoc = this.store.find(Collection.SETTINGS, ID, 0);
        SortedMap data = (SortedMap)cdoc.get(PROP_CHECKPOINT);
        if (data == null) {
            return null;
        }
        TreeMap checkpoints = Maps.newTreeMap(data.comparator());
        for (Map.Entry entry : data.entrySet()) {
            checkpoints.put(entry.getKey(), Info.fromString((String)entry.getValue()));
        }
        return checkpoints;
    }

    int size() {
        SortedMap<Revision, Info> checkpoints = this.getCheckpoints();
        return checkpoints == null ? 0 : checkpoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCleanupIfRequired() {
        if (this.createCounter.get() > 100) {
            Object object = this.cleanupLock;
            synchronized (object) {
                this.getOldestRevisionToKeep();
                this.createCounter.set(0);
            }
        }
    }

    private void createIfNotExist() {
        if (this.store.find(Collection.SETTINGS, ID) == null) {
            UpdateOp updateOp = new UpdateOp(ID, true);
            updateOp.set("_id", ID);
            this.store.createOrUpdate(Collection.SETTINGS, updateOp);
        }
    }

    static final class Info {
        private static final String EXPIRES = "expires";
        private final long expiryTime;
        private final Map<String, String> info;

        private Info(long expiryTime, Map<String, String> info) {
            this.expiryTime = expiryTime;
            this.info = Collections.unmodifiableMap(info);
        }

        static Info fromString(String info) {
            long expiryTime;
            Map<String, String> map;
            if (info.startsWith("{")) {
                map = Maps.newHashMap();
                JsopTokenizer reader = new JsopTokenizer(info);
                reader.read(123);
                String key = reader.readString();
                if (!EXPIRES.equals(key)) {
                    throw new IllegalArgumentException("First entry in the checkpoint info must be the expires date: " + info);
                }
                reader.read(58);
                expiryTime = Long.parseLong(reader.readString());
                while (reader.matches(44)) {
                    key = reader.readString();
                    reader.read(58);
                    map.put(key, reader.readString());
                }
                reader.read(125);
                reader.read(0);
            } else {
                map = Collections.emptyMap();
                expiryTime = Long.parseLong(info);
            }
            return new Info(expiryTime, map);
        }

        Map<String, String> get() {
            return this.info;
        }

        long getExpiryTime() {
            return this.expiryTime;
        }

        public String toString() {
            JsopBuilder writer = new JsopBuilder();
            writer.object();
            writer.key(EXPIRES).value(Long.toString(this.expiryTime));
            for (Map.Entry<String, String> entry : this.info.entrySet()) {
                writer.key(entry.getKey()).value(entry.getValue());
            }
            writer.endObject();
            return ((Object)writer).toString();
        }
    }
}

