/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;

public class ClusterNodeInfoDocument
extends Document {
    private static final String MIN_ID_VALUE = "0";
    private static final String MAX_ID_VALUE = "a";

    public long getLeaseEndTime() {
        return (Long)Preconditions.checkNotNull((Object)((Long)this.get("leaseEnd")), (Object)"Lease End Time not set");
    }

    public boolean isActive() {
        return this.getState() == ClusterNodeInfo.ClusterNodeState.ACTIVE;
    }

    public boolean isBeingRecovered() {
        return this.getRecoveryState() == ClusterNodeInfo.RecoverLockState.ACQUIRED;
    }

    public int getClusterId() {
        return Integer.parseInt(this.getId());
    }

    public static List<ClusterNodeInfoDocument> all(DocumentStore store) {
        return store.query(Collection.CLUSTER_NODES, MIN_ID_VALUE, MAX_ID_VALUE, Integer.MAX_VALUE);
    }

    private ClusterNodeInfo.ClusterNodeState getState() {
        return ClusterNodeInfo.ClusterNodeState.fromString((String)this.get("state"));
    }

    private ClusterNodeInfo.RecoverLockState getRecoveryState() {
        return ClusterNodeInfo.RecoverLockState.fromString((String)this.get("recoveryLock"));
    }
}

