/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Document NodeStore Service", description="NodeStore implementation based on Document model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#DocumentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
public class DocumentNodeStoreService {
    private static final String DEFAULT_URI = "mongodb://localhost:27017/oak";
    private static final int DEFAULT_CACHE = 256;
    private static final int DEFAULT_OFF_HEAP_CACHE = 0;
    private static final int DEFAULT_CHANGES_SIZE = 256;
    private static final int DEFAULT_BLOB_CACHE_SIZE = 16;
    private static final String DEFAULT_DB = "oak";
    private static final String DEFAULT_PERSISTENT_CACHE = "";
    private static final String PREFIX = "oak.documentstore.";
    private static final String DESCRIPTION = "oak.nodestore.description";
    private static final String FWK_PROP_URI = "oak.mongo.uri";
    private static final String FWK_PROP_DB = "oak.mongo.db";
    @Property(value={"mongodb://localhost:27017/oak"}, label="Mongo URI", description="Mongo connection URI used to connect to Mongo. Refer to http://docs.mongodb.org/manual/reference/connection-string/ for details. Note that this value can be overridden via framework property 'oak.mongo.uri'")
    private static final String PROP_URI = "mongouri";
    @Property(value={"oak"}, label="Mongo DB name", description="Name of the database in Mongo. Note that this value can be overridden via framework property 'oak.mongo.db'")
    private static final String PROP_DB = "db";
    @Property(intValue={256}, label="Cache Size (in MB)", description="Cache size in MB. This is distributed among various caches used in DocumentNodeStore")
    private static final String PROP_CACHE = "cache";
    @Property(intValue={25}, label="NodeState Cache", description="Percentage of cache to be allocated towards Node cache")
    private static final String PROP_NODE_CACHE_PERCENTAGE = "nodeCachePercentage";
    @Property(intValue={10}, label="NodeState Children Cache", description="Percentage of cache to be allocated towards Children cache")
    private static final String PROP_CHILDREN_CACHE_PERCENTAGE = "childrenCachePercentage";
    @Property(intValue={5}, label="Diff Cache", description="Percentage of cache to be allocated towards Diff cache")
    private static final String PROP_DIFF_CACHE_PERCENTAGE = "diffCachePercentage";
    @Property(intValue={3}, label="Document Children Cache", description="Percentage of cache to be allocated towards Document children cache")
    private static final String PROP_DOC_CHILDREN_CACHE_PERCENTAGE = "docChildrenCachePercentage";
    private static final String PROP_OFF_HEAP_CACHE = "offHeapCache";
    @Property(intValue={256}, label="Mongo Changes Collection Size (in MB)", description="With the MongoDB backend, the DocumentNodeStore uses a capped collection to cache the diff. This value is used to determine the size of that capped collection")
    private static final String PROP_CHANGES_SIZE = "changesSize";
    @Property(intValue={16}, label="Blob Cache Size (in MB)", description="Cache size to store blobs in memory. Used only with default BlobStore (as per DocumentStore type)")
    private static final String PROP_BLOB_CACHE_SIZE = "blobCacheSize";
    @Property(value={""}, label="Persistent Cache Config", description="Configuration for enabling Persistent cache. By default it is not enabled. Refer to http://jackrabbit.apache.org/oak/docs/nodestore/persistent-cache.html for various options")
    private static final String PROP_PERSISTENT_CACHE = "persistentCache";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default, for MongoDB, MongoBlobStore is used; for RDB, RDBBlobStore is used.")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    @Property(boolValue={false}, label="Custom DataSource", description="Boolean value indicating that DataSource is configured separately, and that it should be used")
    public static final String CUSTOM_BLOB_DATA_SOURCE = "customBlobDataSource";
    private static final long MB = 0x100000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private WhiteboardExecutor executor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile BlobStore blobStore;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    private volatile DataSource dataSource;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    private volatile DataSource blobDataSource;
    private DocumentMK mk;
    private ObserverTracker observerTracker;
    private ComponentContext context;
    private Whiteboard whiteboard;
    private static final long DEFAULT_VER_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Version GC Max Age (in secs)", description="Version Garbage Collector (GC) logic will only consider those deleted for GC which are not accessed recently (currentTime - lastModifiedTime > versionGcMaxAgeInSecs). For example as per default only those document which have been *marked* deleted 24 hrs ago will be considered for GC. This also applies how older revision of live document are GC.")
    public static final String PROP_VER_GC_MAX_AGE = "versionGcMaxAgeInSecs";
    private long versionGcMaxAgeInSecs = 86400L;
    public static final String PROP_REV_RECOVERY_INTERVAL = "lastRevRecoveryJobIntervalInSecs";
    private static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Blob GC Max Age (in secs)", description="Blob Garbage Collector (GC) logic will only consider those blobs for GC which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example as per default only those blobs which have been created 24 hrs ago will be considered for GC")
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";
    private long blobGcMaxAgeInSecs = 86400L;
    private static final long DEFAULT_MAX_REPLICATION_LAG = 21600L;
    @Property(longValue={21600L}, label="Max Replication Lag (in secs)", description="Value in seconds. Determines the duration beyond which it can be safely assumed that the state on the secondaries is consistent with the primary, and it is safe to read from them")
    public static final String PROP_REPLICATION_LAG = "maxReplicationLagInSecs";
    private long maxReplicationLagInSecs = 21600L;
    @Property(options={@PropertyOption(name="MONGO", value="MONGO"), @PropertyOption(name="RDB", value="RDB")}, value={"MONGO"}, label="DocumentStore Type", description="Type of DocumentStore to use for persistence. Defaults to MONGO")
    public static final String PROP_DS_TYPE = "documentStoreType";
    private DocumentStoreType documentStoreType;
    private boolean customBlobStore;
    private boolean customBlobDataSource;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) throws Exception {
        this.context = context;
        this.whiteboard = new OsgiWhiteboard(context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        this.maxReplicationLagInSecs = PropertiesUtil.toLong(config.get(PROP_REPLICATION_LAG), 21600L);
        this.customBlobStore = PropertiesUtil.toBoolean(this.prop(CUSTOM_BLOB_STORE), false);
        this.customBlobDataSource = PropertiesUtil.toBoolean(this.prop(CUSTOM_BLOB_DATA_SOURCE), false);
        this.documentStoreType = DocumentStoreType.fromString(PropertiesUtil.toString(config.get(PROP_DS_TYPE), "MONGO"));
        this.modified(config);
        this.registerNodeStoreIfPossible();
    }

    private void registerNodeStoreIfPossible() throws IOException {
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
        } else if (this.customBlobStore && this.blobStore == null) {
            this.log.info("BlobStore use enabled. DocumentNodeStoreService would be initialized when BlobStore would be available");
        } else if (this.documentStoreType == DocumentStoreType.RDB && (this.dataSource == null || this.customBlobDataSource && this.blobDataSource == null)) {
            this.log.info("DataSource use enabled. DocumentNodeStoreService would be initialized when DataSource would be available");
        } else {
            this.registerNodeStore();
        }
    }

    private void registerNodeStore() throws IOException {
        DocumentNodeStore mns;
        String uri = PropertiesUtil.toString(this.prop(PROP_URI, FWK_PROP_URI), DEFAULT_URI);
        String db = PropertiesUtil.toString(this.prop(PROP_DB, FWK_PROP_DB), DEFAULT_DB);
        int offHeapCache = PropertiesUtil.toInteger(this.prop(PROP_OFF_HEAP_CACHE), 0);
        int cacheSize = PropertiesUtil.toInteger(this.prop(PROP_CACHE), 256);
        int nodeCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_NODE_CACHE_PERCENTAGE), 25);
        int childrenCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_CHILDREN_CACHE_PERCENTAGE), 10);
        int docChildrenCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_DOC_CHILDREN_CACHE_PERCENTAGE), 3);
        int diffCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_DIFF_CACHE_PERCENTAGE), 5);
        int changesSize = PropertiesUtil.toInteger(this.prop(PROP_CHANGES_SIZE), 256);
        int blobCacheSize = PropertiesUtil.toInteger(this.prop(PROP_BLOB_CACHE_SIZE), 16);
        String persistentCache = PropertiesUtil.toString(this.prop(PROP_PERSISTENT_CACHE), DEFAULT_PERSISTENT_CACHE);
        DocumentMK.Builder mkBuilder = new DocumentMK.Builder().memoryCacheSize((long)cacheSize * 0x100000L).memoryCacheDistribution(nodeCachePercentage, childrenCachePercentage, docChildrenCachePercentage, diffCachePercentage).offHeapCacheSize((long)offHeapCache * 0x100000L);
        if (persistentCache != null && persistentCache.length() > 0) {
            mkBuilder.setPersistentCache(persistentCache);
        }
        if (this.customBlobStore) {
            Preconditions.checkNotNull((Object)this.blobStore, (String)"Use of custom BlobStore enabled via  [%s] but blobStore reference not initialized", (Object[])new Object[]{CUSTOM_BLOB_STORE});
            mkBuilder.setBlobStore(this.blobStore);
        }
        if (this.documentStoreType == DocumentStoreType.RDB) {
            Preconditions.checkNotNull((Object)this.dataSource, (String)"DataStore type set [%s] but DataSource reference not initialized", (Object[])new Object[]{PROP_DS_TYPE});
            if (this.customBlobDataSource) {
                Preconditions.checkNotNull((Object)this.blobDataSource, (String)"DataStore type set [%s] and BlobStore is configured to use different DataSource via [%s] but BlobDataSource reference not initialized", (Object[])new Object[]{PROP_DS_TYPE, CUSTOM_BLOB_DATA_SOURCE});
                mkBuilder.setRDBConnection(this.dataSource, this.blobDataSource);
                this.log.info("Connected to datasources {} {}", (Object)this.dataSource, (Object)this.blobDataSource);
            } else {
                mkBuilder.setRDBConnection(this.dataSource);
                this.log.info("Connected to datasource {}", (Object)this.dataSource);
            }
        } else {
            MongoClientOptions.Builder builder = MongoConnection.getDefaultBuilder();
            MongoClientURI mongoURI = new MongoClientURI(uri, builder);
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting DocumentNodeStore with host={}, db={}, cache size (MB)={}, persistentCache={}, 'changes' collection size (MB)={}, blobCacheSize (MB)={}, maxReplicationLagInSecs={}", new Object[]{mongoURI.getHosts(), db, cacheSize, persistentCache, changesSize, blobCacheSize, this.maxReplicationLagInSecs});
                this.log.info("Mongo Connection details {}", (Object)MongoConnection.toString(mongoURI.getOptions()));
            }
            MongoClient client = new MongoClient(mongoURI);
            DB mongoDB = client.getDB(db);
            mkBuilder.setMaxReplicationLag(this.maxReplicationLagInSecs, TimeUnit.SECONDS);
            mkBuilder.setMongoDB(mongoDB, changesSize, blobCacheSize);
            this.log.info("Connected to database {}", (Object)mongoDB);
        }
        mkBuilder.setExecutor(this.executor);
        this.mk = mkBuilder.open();
        if (SharedDataStoreUtils.isShared(this.blobStore)) {
            try {
                String repoId = ClusterRepositoryInfo.createId(this.mk.getNodeStore());
                ((SharedDataStore)((Object)this.blobStore)).addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repoId));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
        }
        this.registerJMXBeans(this.mk.getNodeStore());
        this.registerLastRevRecoveryJob(this.mk.getNodeStore());
        DocumentNodeStore store = mns = this.mk.getNodeStore();
        this.observerTracker = new ObserverTracker(mns);
        this.observerTracker.start(this.context.getBundleContext());
        DocumentStore ds = this.mk.getDocumentStore();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", DocumentNodeStore.class.getName());
        ((Dictionary)props).put(DESCRIPTION, DocumentNodeStoreService.getMetadata(ds));
        this.reg = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)store, props);
    }

    @Modified
    protected void modified(Map<String, ?> config) {
        this.versionGcMaxAgeInSecs = PropertiesUtil.toLong(config.get(PROP_VER_GC_MAX_AGE), 86400L);
        this.blobGcMaxAgeInSecs = PropertiesUtil.toLong(config.get(PROP_BLOB_GC_MAX_AGE), 86400L);
    }

    @Deactivate
    protected void deactivate() {
        if (this.observerTracker != null) {
            this.observerTracker.stop();
        }
        this.unregisterNodeStore();
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.log.info("Initializing DocumentNodeStore with BlobStore [{}]", (Object)blobStore);
        this.blobStore = blobStore;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    protected void bindDataSource(DataSource dataSource) throws IOException {
        this.dataSource = dataSource;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindDataSource(DataSource dataSource) {
        this.dataSource = null;
        this.unregisterNodeStore();
    }

    protected void bindBlobDataSource(DataSource dataSource) throws IOException {
        this.blobDataSource = dataSource;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindBlobDataSource(DataSource dataSource) {
        this.blobDataSource = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        for (Registration r : this.registrations) {
            r.unregister();
        }
        if (this.reg != null) {
            this.reg.unregister();
        }
        if (this.mk != null) {
            this.mk.dispose();
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private void registerJMXBeans(final DocumentNodeStore store) throws IOException {
        DocumentStore ds;
        DiffCache localCache;
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeCacheStats(), "CacheStats", store.getNodeCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeChildrenCacheStats(), "CacheStats", store.getNodeChildrenCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getDocChildrenCacheStats(), "CacheStats", store.getDocChildrenCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CheckpointMBean.class, new DocumentCheckpointMBean(store), "CheckpointManger", "Document node store checkpoint management"));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, DocumentNodeStoreMBean.class, store.getMBean(), "DocumentNodeStore", "Document node store management"));
        DiffCache cl = store.getDiffCache();
        if (cl instanceof MemoryDiffCache) {
            MemoryDiffCache mcl = (MemoryDiffCache)cl;
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, mcl.getDiffCacheStats(), "CacheStats", mcl.getDiffCacheStats().getName()));
        }
        if ((localCache = store.getLocalDiffCache()) instanceof LocalDiffCache) {
            LocalDiffCache mcl = (LocalDiffCache)localCache;
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, mcl.getDiffCacheStats(), "CacheStats", mcl.getDiffCacheStats().getName()));
        }
        if ((ds = store.getDocumentStore()).getCacheStats() != null) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, ds.getCacheStats(), "CacheStats", ds.getCacheStats().getName()));
        }
        if (store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            BlobGarbageCollector gc = new BlobGarbageCollector(){

                @Override
                public void collectGarbage(boolean sweep) throws Exception {
                    store.createBlobGarbageCollector(DocumentNodeStoreService.this.blobGcMaxAgeInSecs, ClusterRepositoryInfo.getId(DocumentNodeStoreService.this.mk.getNodeStore())).collectGarbage(sweep);
                }
            };
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, BlobGCMBean.class, new BlobGC(gc, this.executor), "BlobGarbageCollection", "Document node store blob garbage collection"));
        }
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                try {
                    store.getVersionGarbageCollector().gc(DocumentNodeStoreService.this.versionGcMaxAgeInSecs, TimeUnit.SECONDS);
                }
                catch (IOException e) {
                    DocumentNodeStoreService.this.log.warn("Error occurred while executing the Version Garbage Collector", (Throwable)e);
                }
            }
        }, this.executor);
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, RevisionGCMBean.class, revisionGC, "RevisionGarbageCollection", "Document node store revision garbage collection"));
    }

    private void registerLastRevRecoveryJob(final DocumentNodeStore nodeStore) {
        long leaseTime = PropertiesUtil.toLong(this.context.getProperties().get(PROP_REV_RECOVERY_INTERVAL), 60000L);
        Runnable recoverJob = new Runnable(){

            @Override
            public void run() {
                nodeStore.getLastRevRecoveryAgent().performRecoveryIfNeeded();
            }
        };
        this.registrations.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, recoverJob, TimeUnit.MILLISECONDS.toSeconds(leaseTime)));
    }

    private Object prop(String propName) {
        return this.prop(propName, PREFIX + propName);
    }

    private Object prop(String propName, String fwkPropName) {
        String value = this.context.getBundleContext().getProperty(fwkPropName);
        if (value != null) {
            return value;
        }
        return this.context.getProperties().get(propName);
    }

    private static String[] getMetadata(DocumentStore ds) {
        HashMap<String, String> meta = new HashMap<String, String>(ds.getMetadata());
        meta.put("nodeStoreType", "document");
        String[] result = new String[meta.size()];
        int i = 0;
        for (Map.Entry e : meta.entrySet()) {
            result[i++] = (String)e.getKey() + "=" + (String)e.getValue();
        }
        return result;
    }

    private static enum DocumentStoreType {
        MONGO,
        RDB;


        static DocumentStoreType fromString(String type) {
            if (type == null) {
                return MONGO;
            }
            return DocumentStoreType.valueOf(type.toUpperCase());
        }
    }
}

