/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class MissingLastRevSeeker {
    protected final String ROOT_PATH = "/";
    private final DocumentStore store;

    public MissingLastRevSeeker(DocumentStore store) {
        this.store = store;
    }

    public Iterable<ClusterNodeInfoDocument> getAllClusters() {
        return ClusterNodeInfoDocument.all(this.store);
    }

    public ClusterNodeInfoDocument getClusterNodeInfo(int clusterId) {
        return this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
    }

    public Iterable<NodeDocument> getCandidates(final long startTime) {
        Iterable<NodeDocument> nodes = Utils.getSelectedDocuments(this.store, "_modified", NodeDocument.getModifiedInSecs(startTime));
        return Iterables.filter(nodes, (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                Long modified = (Long)input.get("_modified");
                return modified != null && modified >= NodeDocument.getModifiedInSecs(startTime);
            }
        });
    }

    public boolean acquireRecoveryLock(int clusterId) {
        UpdateOp update = new UpdateOp(Integer.toString(clusterId), true);
        update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
        return true;
    }

    public void releaseRecoveryLock(int clusterId) {
        UpdateOp update = new UpdateOp(Integer.toString(clusterId), true);
        update.set("recoveryLock", null);
        update.set("state", null);
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
    }

    public NodeDocument getRoot() {
        return this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
    }

    public boolean isRecoveryNeeded(long currentTime) {
        for (ClusterNodeInfoDocument nodeInfo : this.getAllClusters()) {
            if (!nodeInfo.isActive() || currentTime <= nodeInfo.getLeaseEndTime() || nodeInfo.isBeingRecovered()) continue;
            return true;
        }
        return false;
    }
}

