/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitDocumentCleanUp {
    private static final Logger LOG = LoggerFactory.getLogger(SplitDocumentCleanUp.class);
    protected final DocumentStore store;
    protected final Iterable<NodeDocument> splitDocGarbage;
    protected final VersionGarbageCollector.VersionGCStats stats;

    protected SplitDocumentCleanUp(DocumentStore store, VersionGarbageCollector.VersionGCStats stats, Iterable<NodeDocument> splitDocGarbage) {
        this.store = store;
        this.stats = stats;
        this.splitDocGarbage = splitDocGarbage;
    }

    protected SplitDocumentCleanUp disconnect() {
        for (NodeDocument splitDoc : this.splitDocGarbage) {
            this.disconnect(splitDoc);
        }
        return this;
    }

    protected int deleteSplitDocuments() {
        ArrayList docsToDelete = Lists.newArrayList((Iterable)Iterables.transform(this.splitDocGarbage, (Function)new Function<NodeDocument, String>(){

            public String apply(NodeDocument input) {
                return input.getId();
            }
        }));
        this.store.remove(Collection.NODES, docsToDelete);
        return docsToDelete.size();
    }

    private void disconnect(NodeDocument splitDoc) {
        String splitId = splitDoc.getId();
        String mainId = Utils.getIdFromPath(splitDoc.getMainPath());
        NodeDocument doc = this.store.find(Collection.NODES, mainId);
        if (doc == null) {
            LOG.warn("Main document {} already removed. Split document is {}", (Object)mainId, (Object)splitId);
            return;
        }
        int slashIdx = splitId.lastIndexOf(47);
        int height = Integer.parseInt(splitId.substring(slashIdx + 1));
        Revision rev = Revision.fromString(splitId.substring(splitId.lastIndexOf(47, slashIdx - 1) + 1, slashIdx));
        if ((doc = doc.findPrevReferencingDoc(rev, height)) == null) {
            LOG.warn("Split document {} not referenced anymore. Main document is {}", (Object)splitId, (Object)mainId);
            return;
        }
        if (doc.getSplitDocType() == NodeDocument.SplitDocType.INTERMEDIATE) {
            this.disconnectFromIntermediate(doc, rev);
        } else {
            this.markStaleOnMain(doc, rev, height);
        }
    }

    private void disconnectFromIntermediate(NodeDocument splitDoc, Revision rev) {
        Preconditions.checkArgument((splitDoc.getSplitDocType() == NodeDocument.SplitDocType.INTERMEDIATE ? 1 : 0) != 0, (String)"Illegal type: %s", (Object[])new Object[]{splitDoc.getSplitDocType()});
        UpdateOp update = new UpdateOp(splitDoc.getId(), false);
        NodeDocument.removePrevious(update, rev);
        NodeDocument old = this.store.findAndUpdate(Collection.NODES, update);
        if (old != null && old.getPreviousRanges().size() == 1 && old.getPreviousRanges().containsKey(rev)) {
            this.disconnect(old);
            this.store.remove(Collection.NODES, old.getId());
            ++this.stats.intermediateSplitDocGCCount;
        }
    }

    final void markStaleOnMain(NodeDocument main, Revision rev, int height) {
        Preconditions.checkArgument((main.getSplitDocType() == NodeDocument.SplitDocType.NONE ? 1 : 0) != 0, (String)"Illegal type: %s", (Object[])new Object[]{main.getSplitDocType()});
        UpdateOp update = new UpdateOp(main.getId(), false);
        NodeDocument.setStalePrevious(update, rev, height);
        this.store.findAndUpdate(Collection.NODES, update);
    }
}

