/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Revision;

public final class UpdateOp {
    final String id;
    private boolean isNew;
    private boolean isDelete;
    private final Map<Key, Operation> changes;

    UpdateOp(String id, boolean isNew) {
        this(id, isNew, false, new HashMap<Key, Operation>());
    }

    private UpdateOp(String id, boolean isNew, boolean isDelete, Map<Key, Operation> changes) {
        this.id = id;
        this.isNew = isNew;
        this.isDelete = isDelete;
        this.changes = changes;
    }

    static UpdateOp combine(String id, Iterable<UpdateOp> ops) {
        HashMap changes = Maps.newHashMap();
        for (UpdateOp op : ops) {
            changes.putAll(op.getChanges());
        }
        return new UpdateOp(id, false, false, changes);
    }

    public UpdateOp shallowCopy(String id) {
        return new UpdateOp(id, this.isNew, this.isDelete, this.changes);
    }

    public UpdateOp copy() {
        return new UpdateOp(this.id, this.isNew, this.isDelete, new HashMap<Key, Operation>(this.changes));
    }

    public String getId() {
        return this.id;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    boolean isDelete() {
        return this.isDelete;
    }

    public Map<Key, Operation> getChanges() {
        return this.changes;
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    void setMapEntry(@Nonnull String property, @Nonnull Revision revision, String value) {
        Operation op = new Operation(Operation.Type.SET_MAP_ENTRY, value);
        this.changes.put(new Key(property, (Revision)Preconditions.checkNotNull((Object)revision)), op);
    }

    public void removeMapEntry(@Nonnull String property, @Nonnull Revision revision) {
        Operation op = new Operation(Operation.Type.REMOVE_MAP_ENTRY, null);
        this.changes.put(new Key(property, (Revision)Preconditions.checkNotNull((Object)revision)), op);
    }

    void set(String property, Object value) {
        Operation op = new Operation(Operation.Type.SET, value);
        this.changes.put(new Key(property, null), op);
    }

    <T> void max(String property, Comparable<T> value) {
        Operation op = new Operation(Operation.Type.MAX, value);
        this.changes.put(new Key(property, null), op);
    }

    void unsetMapEntry(@Nonnull String property, @Nonnull Revision revision) {
        this.changes.remove(new Key(property, (Revision)Preconditions.checkNotNull((Object)revision)));
    }

    void containsMapEntry(@Nonnull String property, @Nonnull Revision revision, boolean exists) {
        if (this.isNew) {
            throw new IllegalStateException("Cannot use containsMapEntry() on new document");
        }
        Operation op = new Operation(Operation.Type.CONTAINS_MAP_ENTRY, exists);
        this.changes.put(new Key(property, (Revision)Preconditions.checkNotNull((Object)revision)), op);
    }

    public void increment(@Nonnull String property, long value) {
        Operation op = new Operation(Operation.Type.INCREMENT, value);
        this.changes.put(new Key(property, null), op);
    }

    public UpdateOp getReverseOperation() {
        UpdateOp reverse = new UpdateOp(this.id, this.isNew);
        for (Map.Entry<Key, Operation> e : this.changes.entrySet()) {
            Operation r = e.getValue().getReverse();
            if (r == null) continue;
            reverse.changes.put(e.getKey(), r);
        }
        return reverse;
    }

    public String toString() {
        return "key: " + this.id + " " + (this.isNew ? "new" : "update") + " " + this.changes;
    }

    public static final class Key {
        private final String name;
        private final Revision revision;

        public Key(@Nonnull String name, @Nullable Revision revision) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.revision = revision;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public Revision getRevision() {
            return this.revision;
        }

        public String toString() {
            String s = this.name;
            if (this.revision != null) {
                s = s + "." + this.revision.toString();
            }
            return s;
        }

        public int hashCode() {
            int hash = this.name.hashCode();
            if (this.revision != null) {
                hash ^= this.revision.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.name.equals(other.name) && (this.revision != null ? this.revision.equals(other.revision) : other.revision == null);
            }
            return false;
        }
    }

    public static final class Operation {
        public final Type type;
        public final Object value;

        Operation(Type type, Object value) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            this.value = value;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.value;
        }

        public Operation getReverse() {
            Operation reverse = null;
            switch (this.type) {
                case INCREMENT: {
                    reverse = new Operation(Type.INCREMENT, -((Long)this.value).longValue());
                    break;
                }
                case SET: 
                case MAX: 
                case REMOVE_MAP_ENTRY: 
                case CONTAINS_MAP_ENTRY: {
                    break;
                }
                case SET_MAP_ENTRY: {
                    reverse = new Operation(Type.REMOVE_MAP_ENTRY, null);
                }
            }
            return reverse;
        }

        public static enum Type {
            SET,
            MAX,
            INCREMENT,
            SET_MAP_ENTRY,
            REMOVE_MAP_ENTRY,
            CONTAINS_MAP_ENTRY;

        }
    }
}

